/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.NO_MEMORY;

public final class BufferManager {
    private static int MAX;
    private static final int MIN_OFFSET = 5;
    private static final int THRESHOLD = 20;
    private static final int MEM_BUFSIZE = 256;
    private static final int MIN_PREFERRED_BUFS = 10;
    private static int time;
    private static BufferManager singleton;
    private List[] bufferPool;
    private byte[] bufferMax = null;
    private Reaper reaper;

    public static final BufferManager getInstance() {
        return singleton;
    }

    private static final int log2up(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2;
    }

    private static final int log2down(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    public final byte[] getPreferredMemoryBuffer() {
        return this.getBuffer(256);
    }

    public final synchronized byte[] getBuffer(int n) {
        return this.getBuffer(n, false);
    }

    public final synchronized byte[] getBuffer(int n, boolean bl) {
        byte[] byArray;
        int n2 = BufferManager.log2up(n);
        if (n2 >= MAX) {
            try {
                if (!bl || time < 0) {
                    byArray = new byte[n];
                }
                if (this.bufferMax == null || this.bufferMax.length < n) {
                    this.bufferMax = new byte[n * 2];
                }
                byArray = this.bufferMax;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Debug.output(2, "BufferManager failed to allocate sufficient memory for byte array");
                throw new NO_MEMORY();
            }
        } else {
            List list = this.bufferPool[n2 > 5 ? n2 - 5 : 0];
            byArray = !list.isEmpty() ? (byte[])list.remove(list.size() - 1) : new byte[n2 > 5 ? 1 << n2 : 32];
        }
        return byArray;
    }

    public final synchronized void returnBuffer(byte[] byArray) {
        this.returnBuffer(byArray, false);
    }

    final synchronized void returnBuffer(byte[] byArray, boolean bl) {
        int n;
        if (byArray != null && (n = BufferManager.log2down(byArray.length)) >= 5) {
            if (n > MAX) {
                if (bl && time >= 0 && (this.bufferMax == null || this.bufferMax.length < byArray.length)) {
                    this.bufferMax = byArray;
                }
                return;
            }
            List list = this.bufferPool[n - 5];
            if (list.size() < 20) {
                list.add(byArray);
            }
        }
    }

    public final void release() {
        int n = MAX;
        while (n > 0) {
            this.bufferPool[--n].clear();
        }
        if (this.reaper != null) {
            this.reaper.done = true;
            this.reaper.wake();
        }
    }

    private BufferManager() {
        MAX = Environment.getMaxManagedBufSize();
        this.bufferPool = new List[MAX];
        int n = 0;
        while (n < MAX) {
            this.bufferPool[n] = new ArrayList();
            ++n;
        }
        n = 0;
        int n2 = 256;
        while (n2 > 1) {
            n2 >>= 1;
            ++n;
        }
        int n3 = 0;
        while (n3 < 10) {
            this.bufferPool[n - 5].add(new byte[256]);
            ++n3;
        }
        if (time > 0) {
            this.reaper = new Reaper(time);
            this.reaper.setName("BufferManager MaxCache Reaper");
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    static {
        time = 0;
        if (Environment.hasProperty("jacorb.bufferManagerMaxFlush")) {
            time = Environment.getIntProperty("jacorb.bufferManagerMaxFlush", 10);
        }
        singleton = new BufferManager();
    }

    private class Reaper
    extends Thread {
        public boolean done = false;
        private int sleepInterval = 0;

        public void run() {
            while (true) {
                try {
                    long l = (long)this.sleepInterval + System.currentTimeMillis();
                    do {
                        Thread.sleep(this.sleepInterval);
                    } while (System.currentTimeMillis() <= l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) break;
                if (Debug.isDebugEnabled()) {
                    Debug.output(4, "Reaper thread purging maxBufferCache. It had size: " + (BufferManager.this.bufferMax == null ? 0 : BufferManager.this.bufferMax.length));
                }
                BufferManager.this.bufferMax = null;
            }
        }

        public synchronized void wake() {
            this.notify();
        }

        public Reaper(int n) {
            this.sleepInterval = n * 1000;
        }
    }
}

