/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Enumeration;
import org.jacorb.orb.ApplicationExceptionHelper;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;

public class ClientInterceptorHandler {
    private ClientRequestInfoImpl info = null;

    public void handle_send_request() throws RemarshalException {
        if (this.info != null) {
            this.invokeInterceptors(this.info, (short)0);
            Enumeration enumeration = this.info.getRequestServiceContexts();
            while (enumeration.hasMoreElements()) {
                this.info.request_os.addServiceContext((ServiceContext)enumeration.nextElement());
            }
        }
    }

    public void handle_location_forward(ReplyInputStream replyInputStream, Object object) throws RemarshalException {
        if (this.info != null) {
            this.info.reply_status = (short)3;
            this.info.setReplyServiceContexts(replyInputStream.rep_hdr.service_context);
            this.info.forward_reference = object;
            this.info.reply_is = replyInputStream;
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    public void handle_receive_reply(ReplyInputStream replyInputStream) throws RemarshalException {
        if (this.info != null) {
            ReplyHeader_1_2 replyHeader_1_2 = replyInputStream.rep_hdr;
            if (replyHeader_1_2.reply_status.value() == 0) {
                this.info.reply_status = 0;
                this.info.setReplyServiceContexts(replyHeader_1_2.service_context);
                if (this.info.request_os.getRequest() == null) {
                    InterceptorManager interceptorManager = this.info.orb.getInterceptorManager();
                    this.info.current = interceptorManager.getCurrent();
                    this.info.reply_is = replyInputStream;
                    this.invokeInterceptors(this.info, (short)2);
                } else {
                    this.info.request_os.getRequest().setInfo(this.info);
                }
            }
        }
    }

    public void handle_receive_other(short s) throws RemarshalException {
        if (this.info != null) {
            this.info.reply_status = s;
            this.invokeInterceptors(this.info, (short)4);
        }
    }

    public void handle_receive_exception(SystemException systemException) throws RemarshalException {
        this.handle_receive_exception(systemException, null);
    }

    public void handle_receive_exception(SystemException systemException, ReplyInputStream replyInputStream) throws RemarshalException {
        if (this.info != null) {
            SystemExceptionHelper.insert(this.info.received_exception, systemException);
            try {
                this.info.received_exception_id = SystemExceptionHelper.type(systemException).id();
            }
            catch (BadKind badKind) {
                Debug.output(4, badKind);
            }
            this.info.reply_status = 1;
            if (replyInputStream != null) {
                this.info.setReplyServiceContexts(replyInputStream.rep_hdr.service_context);
                this.info.reply_is = replyInputStream;
            }
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    public void handle_receive_exception(ApplicationException applicationException, ReplyInputStream replyInputStream) throws RemarshalException {
        if (this.info != null) {
            this.info.received_exception_id = applicationException.getId();
            try {
                ApplicationExceptionHelper.insert(this.info.received_exception, applicationException);
            }
            catch (Exception exception) {
                Debug.output(4, exception);
                SystemExceptionHelper.insert(this.info.received_exception, new UNKNOWN(exception.getMessage()));
            }
            this.info.reply_status = (short)2;
            try {
                replyInputStream.reset();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
            this.info.setReplyServiceContexts(replyInputStream.rep_hdr.service_context);
            this.info.reply_is = replyInputStream;
            this.invokeInterceptors(this.info, (short)3);
        }
    }

    private final void invokeInterceptors(ClientRequestInfoImpl clientRequestInfoImpl, short s) throws RemarshalException {
        ClientInterceptorIterator clientInterceptorIterator = clientRequestInfoImpl.orb.getInterceptorManager().getClientIterator();
        try {
            clientInterceptorIterator.iterate(clientRequestInfoImpl, s);
        }
        catch (ForwardRequest forwardRequest) {
            clientRequestInfoImpl.delegate.rebind(clientRequestInfoImpl.orb.object_to_string(forwardRequest.forward));
            throw new RemarshalException();
        }
        catch (UserException userException) {
            Debug.output(2, userException);
        }
    }

    public ClientInterceptorHandler(ORB oRB, RequestOutputStream requestOutputStream, Object object, Delegate delegate, ParsedIOR parsedIOR, ClientConnection clientConnection) {
        if (oRB.hasClientRequestInterceptors()) {
            this.info = new ClientRequestInfoImpl(oRB, requestOutputStream, object, delegate, parsedIOR, clientConnection);
        }
    }
}

