/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.dns.DNSLookup;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress {
    private String hostname = null;
    private String ip = null;
    private int port;

    public static IIOPAddress read(InputStream inputStream) {
        String string = inputStream.read_string();
        short s = inputStream.read_ushort();
        return new IIOPAddress(string, s);
    }

    private static final boolean isIP(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 32;
        int n5 = 0;
        while (n5 < 4) {
            while (n < n3 && (n4 = (int)string.charAt(n)) != 46) {
                if (n4 < 48 || n4 > 57) {
                    return false;
                }
                ++n;
            }
            if (n >= n3 && n5 == 3 && n - n2 <= 3 && n - n2 > 0) {
                return true;
            }
            if (n4 != 46 || n - n2 > 3 || n - n2 <= 0) {
                return false;
            }
            n2 = ++n;
            ++n5;
        }
        return false;
    }

    public String getIP() {
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getByName(this.hostname).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException("could not resolve hostname: " + this.hostname);
            }
        }
        return this.ip;
    }

    public String getHostname() {
        if (this.hostname == null) {
            this.hostname = DNSLookup.inverseLookup(this.ip);
            if (this.hostname == null) {
                this.hostname = this.ip;
            }
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object instanceof IIOPAddress) {
            IIOPAddress iIOPAddress = (IIOPAddress)object;
            if (this.port == iIOPAddress.port) {
                return this.getIP().equals(iIOPAddress.getIP());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getIP().hashCode() + this.port;
    }

    public String toString() {
        if (this.hostname != null) {
            return this.hostname + ":" + this.port;
        }
        return this.ip + ":" + this.port;
    }

    public byte[] toCDR() {
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        cDROutputStream.write_string(this.ip);
        cDROutputStream.write_ushort((short)this.port);
        return cDROutputStream.getBufferCopy();
    }

    public IIOPAddress(String string, int n) {
        if (IIOPAddress.isIP(string)) {
            this.ip = string;
        } else {
            this.hostname = string;
        }
        this.port = n < 0 ? n + 65536 : n;
    }
}

