/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.Servant;
import org.omg.SecurityLevel2.Current;

public final class ORB
extends ORBSingleton
implements POAListener {
    private static final String versionString = "2.1";
    private static final String dateString = "16-Feb-2004";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    public static final String orb_id = "jacorb:2.1";
    private static TCKind kind;
    private static final String[] services;
    private Map initial_references = new HashMap();
    private POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private BufferManager bufferManager = BufferManager.getInstance();
    protected Map valueFactories = new HashMap();
    protected Map boxedValueHelpers = new HashMap();
    private Map objectKeyMap = new HashMap();
    private Properties _props;
    private Logger logger;
    public String[] _args;
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private ImRAccess imr = null;
    private int persistentPOACount;
    private Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private PolicyManager policyManager = null;
    private Map policy_factories = null;
    private boolean bidir_giop = false;
    private static /* synthetic */ Class class$Lorg$omg$CORBA$ORB;
    private static /* synthetic */ Class class$Lorg$omg$CORBA$portable$ValueFactory;

    public final String id() {
        return orb_id;
    }

    public final boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public final void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public final synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        String string = parsedIOR.getIORString();
        ObjectImpl objectImpl = (ObjectImpl)this.knownReferences.get(string);
        if (objectImpl != null) {
            delegate = (Delegate)objectImpl._get_delegate();
            if (delegate != null) {
                ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                if (parsedIOR2 == null) {
                    this.knownReferences.remove(string);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removing an invalid reference from cache.");
                    }
                } else if (parsedIOR.getEffectiveProfile().is_match(parsedIOR2.getEffectiveProfile())) {
                    return objectImpl._duplicate();
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove stale reference from cache ");
                }
                this.knownReferences.remove(string);
            }
        }
        delegate = new Delegate(this, parsedIOR);
        objectImpl = delegate.getReference(null);
        if (Environment.cacheReferences()) {
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    final POA findPOA(Delegate delegate, Object object) {
        String string = null;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        String string2 = Environment.getProperty("jacorb.implname", "");
        try {
            string = POAUtil.extractImplName(delegate.getObjectKey());
        }
        catch (POAInternalError pOAInternalError) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA");
            }
            return null;
        }
        if (string == null) {
            if (string2.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch");
                }
                return null;
            }
        } else if (!string2.equals(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch");
            }
            return null;
        }
        try {
            POA pOA = this.rootpoa;
            String string3 = POAUtil.extractPOAName(delegate.getObjectKey());
            List list = POAUtil.extractScopedPOANames(string3);
            int n = 0;
            while (n < list.size()) {
                String string4 = (String)list.get(n);
                if (string4.equals("")) break;
                try {
                    pOA = pOA._getChildPOA(string4);
                }
                catch (ParentIsHolding parentIsHolding) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
                ++n;
            }
            byte[] byArray = POAUtil.extractOID(object);
            if (pOA.isSystemId() && !pOA.previouslyGeneratedObjectId(byArray)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return pOA;
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public final ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public final GIOPConnectionManager getGIOPConnectionManager() {
        return this.giop_connection_manager;
    }

    final synchronized void _release(String string) {
        this.knownReferences.remove(string);
    }

    public final Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 34: {
                return new MaxHopsPolicy(any);
            }
            case 35: {
                return new QueueOrderPolicy(any);
            }
            case 23: {
                return new RebindPolicy(any);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(any);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(any);
            }
            case 30: {
                return new ReplyEndTimePolicy(any);
            }
            case 26: {
                return new ReplyPriorityPolicy(any);
            }
            case 29: {
                return new ReplyStartTimePolicy(any);
            }
            case 28: {
                return new RequestEndTimePolicy(any);
            }
            case 25: {
                return new RequestPriorityPolicy(any);
            }
            case 27: {
                return new RequestStartTimePolicy(any);
            }
            case 33: {
                return new RoutingPolicy(any);
            }
            case 24: {
                return new SyncScopePolicy(any);
            }
        }
        Integer n2 = new Integer(n);
        if (this.policy_factories == null || !this.policy_factories.containsKey(n2)) {
            throw new PolicyError();
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(n2);
        return policyFactory.create_policy(n, any);
    }

    public final boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(n));
    }

    public final ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public final org.omg.CORBA.Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    public final OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    final IOR createIOR(String string, byte[] byArray, boolean bl, POA pOA, Map map) {
        java.lang.Object object;
        TaggedProfile[] taggedProfileArray;
        IDLEntity iDLEntity;
        ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
        HashMap<Integer, java.lang.Object> hashMap = new HashMap<Integer, java.lang.Object>();
        java.lang.Object object2 = this.basicAdapter.getEndpointProfiles().iterator();
        while (object2.hasNext()) {
            iDLEntity = (Profile)object2.next();
            iDLEntity.set_object_key(byArray);
            arrayList.add(iDLEntity);
            taggedProfileArray = new TaggedComponentList();
            taggedProfileArray.addComponent(this.create_ORB_TYPE_ID());
            hashMap.put(new Integer(iDLEntity.tag()), taggedProfileArray);
            if (!(iDLEntity instanceof IIOPProfile)) continue;
            this.patchAddress((IIOPProfile)iDLEntity, string, bl);
        }
        object2 = new TaggedComponentList();
        hashMap.put(new Integer(1), object2);
        if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
            iDLEntity = new IORInfoImpl(this, pOA, hashMap, map, arrayList);
            try {
                this.interceptor_manager.getIORIterator().iterate((IORInfoImpl)iDLEntity);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        if ((iDLEntity = this.findIIOPProfile(arrayList)) != null && (Environment.giopMinorVersion() == 0 || Environment.giopAdd_1_0_Profiles())) {
            taggedProfileArray = ((IIOPProfile)iDLEntity).to_GIOP_1_0();
            arrayList.add(taggedProfileArray);
            object = (TaggedComponentList)hashMap.get(new Integer(0));
            ((TaggedComponentList)object2).addAll(((IIOPProfile)iDLEntity).getComponents());
            ((TaggedComponentList)object2).addAll((TaggedComponentList)object);
            if (Environment.giopMinorVersion() == 0) {
                arrayList.remove(iDLEntity);
            }
        }
        taggedProfileArray = null;
        if (((TaggedComponentList)object2).isEmpty()) {
            taggedProfileArray = new TaggedProfile[arrayList.size()];
        } else {
            taggedProfileArray = new TaggedProfile[arrayList.size() + 1];
            taggedProfileArray[taggedProfileArray.length - 1] = this.createMultipleComponentsProfile((TaggedComponentList)object2);
        }
        object = new TaggedProfileHolder();
        TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
        int n = 0;
        while (n < arrayList.size()) {
            Profile profile = (Profile)arrayList.get(n);
            TaggedComponentList taggedComponentList = (TaggedComponentList)hashMap.get(new Integer(profile.tag()));
            taggedComponentSeqHolder.value = taggedComponentList.asArray();
            profile.marshal((TaggedProfileHolder)object, taggedComponentSeqHolder);
            taggedProfileArray[n] = ((TaggedProfileHolder)object).value;
            ++n;
        }
        return new IOR(string, taggedProfileArray);
    }

    private final TaggedProfile createMultipleComponentsProfile(TaggedComponentList taggedComponentList) {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentList.asArray());
        return new TaggedProfile(1, cDROutputStream.getBufferCopy());
    }

    private final IIOPProfile findIIOPProfile(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!(profile instanceof IIOPProfile)) continue;
            return (IIOPProfile)profile;
        }
        return null;
    }

    public final Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public final BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public final org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public final Object getReference(POA pOA, byte[] byArray, String string, boolean bl) {
        if (string == null) {
            string = "IDL:omg.org/CORBA/Object:1.0";
        }
        IOR iOR = this.createIOR(string, byArray, bl, pOA, null);
        Delegate delegate = new Delegate(this, iOR);
        return delegate.getReference(pOA);
    }

    public final POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = POA._POA_init(this);
            this.rootpoa._addPOAEventListener(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.transport_manager, this.giop_connection_manager);
        }
        return this.rootpoa;
    }

    public final boolean isApplet() {
        return this.applet != null;
    }

    public final Applet getApplet() {
        return this.applet;
    }

    public final String[] list_initial_services() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.initial_references.keySet().iterator();
        while (stringArray.hasNext()) {
            arrayList.add(stringArray.next());
        }
        stringArray = new String[services.length + arrayList.size()];
        arrayList.toArray(stringArray);
        System.arraycopy(services, 0, stringArray, arrayList.size(), services.length);
        return stringArray;
    }

    public final void poaCreated(POA pOA) {
        pOA._addPOAEventListener(this);
        if (pOA.isPersistent()) {
            ++this.persistentPOACount;
            this.getImR();
            if (this.imr != null) {
                String string = new String(Environment.implName());
                this.imr.registerPOA(string + "/" + pOA._getQualifiedName(), string, this.getServerAddress(), this.getServerPort());
            }
        }
    }

    private final void getImR() {
        if (this.imr == null && Environment.useImR()) {
            try {
                this.imr = ImRAccessImpl.connect(this);
            }
            catch (Exception exception) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error: No connection to ImplementationRepository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                if (exception instanceof INTERNAL) {
                    throw new OBJ_ADAPTER("Unable to resolve ImR");
                }
                if (exception instanceof TRANSIENT) {
                    throw (TRANSIENT)exception;
                }
                throw new OBJ_ADAPTER(exception.toString());
            }
        }
    }

    private final void patchAddress(IIOPProfile iIOPProfile, String string, boolean bl) {
        if (string.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0")) {
            iIOPProfile.patchPrimaryAddress(Environment.imrProxyHost(), Environment.imrProxyPort());
        } else if (!bl && Environment.useImR() && Environment.useImREndpoint()) {
            this.getImR();
            iIOPProfile.patchPrimaryAddress(this.imr.getImRHost(), this.imr.getImRPort());
            iIOPProfile.patchPrimaryAddress(Environment.imrProxyHost(), Environment.imrProxyPort());
        } else {
            iIOPProfile.patchPrimaryAddress(Environment.iorProxyHost(), Environment.iorProxyPort());
        }
    }

    private final TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        cDROutputStream.write_long(1245790976);
        return new TaggedComponent(0, cDROutputStream.getBufferCopy());
    }

    private final String getServerAddress() {
        String string = Environment.getProperty("jacorb.ior_proxy_host");
        if (string == null) {
            string = this.getBasicAdapter().getAddress();
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy host " + string + " in IOR");
        }
        return string;
    }

    private final int getServerPort() {
        String string = Environment.getProperty("jacorb.ior_proxy_port");
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_QOS("Unable to create integer from string >>" + string + "<<. " + "(check property \"jacorb.ior_proxy_port\")");
            }
            if (n < 0) {
                throw new BAD_QOS("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using proxy port " + n + " in IOR");
            }
        } else {
            n = this.getBasicAdapter().getPort();
        }
        return n;
    }

    private final String getIMRAddressForIOR(String string) {
        String string2 = Environment.getProperty("jacorb.imr.ior_proxy_host");
        return string2 == null ? string : string2;
    }

    private final int getIMRPortForIOR(int n) {
        block3: {
            String string = Environment.getProperty("jacorb.imr.ior_proxy_port");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("IMR Proxy Port is configured to a none integer value. Check the value of property \"jacorb.imr.ior_proxy_port");
                }
            }
        }
        return n;
    }

    public final void poaStateChanged(POA pOA, int n) {
        if ((n == 4 || n == 3) && pOA.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            this.imr.setServerDown(new String(Environment.implName()));
        }
    }

    public final void referenceCreated(Object object) {
    }

    public final boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        throw new NO_IMPLEMENT();
    }

    public final Object resolve_initial_references(String string) throws InvalidName {
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        Object object = null;
        String string2 = Environment.getProperty("ORBInitRef." + string);
        if (string2 != null) {
            try {
                object = this.string_to_object(string2);
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create initial reference for \"" + string + "\"\n" + "Please check property \"ORBInitRef." + string + "\"");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                throw new InvalidName();
            }
        }
        if (string.equals("NameService") && this.isApplet()) {
            String string3 = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
            object = this.string_to_object(string3);
            if (object != null && !object._is_a(NamingContextHelper.id())) {
                object = null;
            }
        } else {
            if (string.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (string.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (string.equals("SecurityCurrent")) {
                block23: {
                    if (this.securityCurrent == null) {
                        try {
                            Class clazz = Environment.classForName("org.jacorb.security.level2.CurrentImpl");
                            Constructor constructor = clazz.getConstructor(class$Lorg$omg$CORBA$ORB != null ? class$Lorg$omg$CORBA$ORB : (class$Lorg$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")));
                            this.securityCurrent = (Current)constructor.newInstance(this);
                            Method method = clazz.getDeclaredMethod("init", new Class[0]);
                            method.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[0]);
                        }
                        catch (Exception exception) {
                            if (!this.logger.isWarnEnabled()) break block23;
                            this.logger.warn(exception.getMessage());
                        }
                    }
                }
                object = this.securityCurrent;
            } else if (string.equals("DynAnyFactory")) {
                object = new DynAnyFactoryImpl(this);
            } else {
                if (string.equals("PICurrent")) {
                    return this.piCurrent;
                }
                if (string.equals("ORBPolicyManager")) {
                    return this.getPolicyManager();
                }
                if (string.equals("CodecFactory")) {
                    object = new CodecFactoryImpl(this);
                } else {
                    throw new InvalidName();
                }
            }
        }
        if (object != null) {
            this.initial_references.put(string, object);
        }
        return object;
    }

    final PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public final void register_initial_reference(String string, Object object) throws InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + string);
        }
        this.initial_references.put(string, object);
    }

    public final void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    public final void send_multiple_requests_oneway(org.omg.CORBA.Request[] requestArray) {
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n].send_oneway();
            ++n;
        }
    }

    public final void send_multiple_requests_deferred(org.omg.CORBA.Request[] requestArray) {
        int n = 0;
        while (n < requestArray.length) {
            requestArray[n].send_deferred();
            ++n;
        }
    }

    public final boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                Request request = (Request)iterator.next();
                if (!request.poll_response()) continue;
                this.request = request;
                return true;
            }
        }
        return false;
    }

    public final org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request request = null;
            if (this.request != null) {
                this.request.get_response();
                request = this.request;
                this.request = null;
                return request;
            }
            block3: while (true) {
                Iterator iterator = this.requests.iterator();
                do {
                    if (!iterator.hasNext()) continue block3;
                } while (!(request = (Request)iterator.next()).poll_response());
                break;
            }
            request.get_response();
            return request;
        }
    }

    public final void addRequest(org.omg.CORBA.Request request) {
        this.requests.add(request);
    }

    public final void removeRequest(org.omg.CORBA.Request request) {
        this.requests.remove(request);
    }

    protected final void set_parameters(String[] stringArray, Properties properties) {
        String string;
        if (properties != null) {
            this._props = properties;
            Environment.addProperties(properties);
        }
        if (stringArray != null) {
            this._args = stringArray;
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                String string2;
                string = stringArray[n].trim();
                if (string.startsWith("-ORBInitRef.")) {
                    string2 = string.substring(1);
                    n2 = string2.indexOf(61);
                    if (n2 == -1) {
                        throw new BAD_PARAM("InitRef format invalid for " + string2);
                    }
                    Environment.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
                } else if (string.equals("-ORBInitRef")) {
                    if (stringArray.length - 1 < n + 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("WARNING: -ORBInitRef argument without value");
                        }
                    } else {
                        if ((n2 = (string2 = stringArray[++n].trim()).indexOf(61)) == -1) {
                            throw new BAD_PARAM("InitRef format invalid for " + string2);
                        }
                        Environment.setProperty("ORBInitRef." + string2.substring(0, n2), string2.substring(n2 + 1));
                    }
                }
                ++n;
            }
        }
        this.policyManager = new PolicyManager(this);
        this.transport_manager = new TransportManager(this);
        this.giop_connection_manager = new GIOPConnectionManager();
        this.clientConnectionManager = new ClientConnectionManager(this, this.transport_manager, this.giop_connection_manager);
        String string3 = Environment.getProperty("jacorb.hashtable_class");
        if (string3 == null || string3.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)Environment.classForName(string3).newInstance();
            }
            catch (Exception exception) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(exception.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.objectKeyMap = Environment.getProperties("jacorb.orb.objectKeyMap", true);
        string = Environment.getProperty("jacorb.orb.print_version");
        if (string != null && string.equals("on")) {
            System.out.println("\tJacORB V 2.1, www.jacorb.org");
            System.out.println("\t(C) Gerald Brose, XTRADYNE Technologies/FU Berlin, 16-Feb-2004");
        }
        this.interceptorInit();
    }

    protected final void set_parameters(Applet applet, Properties properties) {
        this.applet = applet;
        this._props = properties;
        Environment.addProperties(properties);
        this.transport_manager = new TransportManager(this);
        this.giop_connection_manager = new GIOPConnectionManager();
        this.policyManager = new PolicyManager(this);
        this.clientConnectionManager = new ClientConnectionManager(this, this.transport_manager, this.giop_connection_manager);
        String string = Environment.getProperty("jacorb.hashtable_class");
        if (string == null || string.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)Environment.classForName(string).newInstance();
            }
            catch (Exception exception) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.interceptorInit();
    }

    private final void interceptorInit() {
        Vector vector = Environment.getORBInitializers();
        if (vector.size() > 0) {
            ORBInitializer oRBInitializer;
            ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
            int n = 0;
            while (n < vector.size()) {
                block8: {
                    try {
                        oRBInitializer = (ORBInitializer)vector.elementAt(n);
                        oRBInitializer.pre_init(oRBInitInfoImpl);
                    }
                    catch (Exception exception) {
                        if (!this.logger.isWarnEnabled()) break block8;
                        this.logger.warn(exception.getMessage());
                    }
                }
                ++n;
            }
            n = 0;
            while (n < vector.size()) {
                block9: {
                    try {
                        oRBInitializer = (ORBInitializer)vector.elementAt(n);
                        oRBInitializer.post_init(oRBInitInfoImpl);
                    }
                    catch (Exception exception) {
                        if (!this.logger.isWarnEnabled()) break block9;
                        this.logger.warn(exception.getMessage());
                    }
                }
                ++n;
            }
            oRBInitInfoImpl.setInvalid();
            Vector vector2 = oRBInitInfoImpl.getClientInterceptors();
            Vector vector3 = oRBInitInfoImpl.getServerInterceptors();
            Vector vector4 = oRBInitInfoImpl.getIORInterceptors();
            this.hasClientInterceptors = vector2.size() > 0;
            boolean bl = this.hasServerInterceptors = vector3.size() > 0;
            if (this.hasClientInterceptors || this.hasServerInterceptors || vector4.size() > 0) {
                this.interceptor_manager = new InterceptorManager(vector2, vector3, vector4, oRBInitInfoImpl.getSlotCount(), this);
            }
            this.policy_factories = oRBInitInfoImpl.getPolicyFactories();
        }
    }

    public final void shutdown(boolean bl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ORB going down...");
            }
            if (this.shutdown_in_progress && bl) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ORB going shutdown complete (1)");
                    }
                    return;
                }
            }
            if (this.shutdown_in_progress && !bl) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB going shutdown complete (2)");
                }
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ORB going shutdown (cleaning up ORB...)");
        }
        this.clientConnectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_synch.notifyAll();
        }
        object = this.orb_synch;
        synchronized (object) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    public final void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    public final Object string_to_object(String string) {
        if (string == null) {
            return null;
        }
        try {
            ParsedIOR parsedIOR = new ParsedIOR(string, this);
            if (parsedIOR.isNull()) {
                return null;
            }
            return this._getObject(parsedIOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(illegalArgumentException.getMessage());
            }
            return null;
        }
    }

    public final Object get_value_def(String string) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public final void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)object)._get_delegate();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            ServantDelegate servantDelegate = new ServantDelegate(this);
            ((Servant)object)._set_delegate(servantDelegate);
        }
    }

    public final void useProxy() {
        this.applet = new Applet();
    }

    public final String object_to_string(Object object) {
        if (object == null) {
            return nullIORString;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public final void perform_work() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
    }

    public final boolean work_pending() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public final ValueFactory register_value_factory(String string, ValueFactory valueFactory) {
        return this.valueFactories.put(string, valueFactory);
    }

    public final void unregister_value_factory(String string) {
        this.valueFactories.remove(string);
    }

    public final ValueFactory lookup_value_factory(String string) {
        ValueFactory valueFactory = (ValueFactory)this.valueFactories.get(string);
        if (valueFactory == null && string.startsWith("IDL")) {
            String string2 = RepositoryID.className(string);
            valueFactory = this.findValueFactory(string2);
            this.valueFactories.put(string, valueFactory);
        }
        return valueFactory;
    }

    private final ValueFactory findValueFactory(String string) {
        Class clazz = null;
        clazz = this.findClass(string + "DefaultFactory", true);
        if (clazz != null) {
            return (ValueFactory)this.instantiate(clazz);
        }
        Class clazz2 = this.findClass(string, false);
        clazz = this.findClass(string + "Impl", false);
        if (clazz != null && clazz2.isAssignableFrom(clazz)) {
            if ((class$Lorg$omg$CORBA$portable$ValueFactory != null ? class$Lorg$omg$CORBA$portable$ValueFactory : (class$Lorg$omg$CORBA$portable$ValueFactory = ORB.class$("org.omg.CORBA.portable.ValueFactory"))).isAssignableFrom(clazz)) {
                return (ValueFactory)this.instantiate(clazz);
            }
            return new JacORBValueFactory(clazz);
        }
        return null;
    }

    private final Class findClass(String string, boolean bl) {
        Class clazz;
        block4: {
            clazz = null;
            try {
                clazz = Environment.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!bl || !string.startsWith("org.omg")) break block4;
                try {
                    clazz = Environment.classForName("omg.org" + string.substring(7));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    private final java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public final BoxedValueHelper getBoxedValueHelper(String string) {
        BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.boxedValueHelpers.get(string);
        if (boxedValueHelper == null) {
            if (this.boxedValueHelpers.containsKey(string)) {
                return null;
            }
            boxedValueHelper = RepositoryID.createBoxedValueHelper(string);
            this.boxedValueHelpers.put(string, boxedValueHelper);
        }
        return boxedValueHelper;
    }

    public final boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public final boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public final boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public final InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public final TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
        }
        return this.transport_manager;
    }

    public final org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    public final org.omg.CORBA.NVList create_list(int n) {
        return new NVList(this, n);
    }

    public final org.omg.CORBA.NamedValue create_named_value(String string, Any any, int n) {
        return new NamedValue(string, any, n);
    }

    public final org.omg.CORBA.NVList create_operation_list(Object object) {
        if (!(object instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef operationDef = (OperationDef)object;
        return this.create_operation_list(operationDef);
    }

    public final org.omg.CORBA.NVList create_operation_list(OperationDef operationDef) {
        int n = 0;
        ParameterDescription[] parameterDescriptionArray = null;
        parameterDescriptionArray = operationDef.params();
        if (parameterDescriptionArray != null) {
            n = parameterDescriptionArray.length;
        }
        NVList nVList = new NVList(this, n);
        int n2 = 0;
        while (n2 < n) {
            ParameterDescription parameterDescription = parameterDescriptionArray[n2];
            Any any = this.create_any();
            any.type(parameterDescription.type);
            ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, parameterDescription.mode.value());
            ++n2;
        }
        return nVList;
    }

    public final void addObjectKey(String string, String string2) {
        this.objectKeyMap.put(string, string2);
    }

    public final byte[] mapObjectKey(byte[] byArray) {
        java.lang.Object var2_2 = null;
        java.lang.Object var3_3 = null;
        ParsedIOR parsedIOR = null;
        String string = null;
        String string2 = null;
        if (this.objectKeyMap.size() != 0 && (string = (String)this.objectKeyMap.get(string2 = new String(byArray))) != null) {
            if (ParsedIOR.isParsableProtocol(string)) {
                try {
                    parsedIOR = new ParsedIOR(string, this);
                    return parsedIOR.get_object_key();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error - could not read protocol " + string);
                    }
                    return byArray;
                }
            }
            return CorbaLoc.parseKey(string);
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ORB() {
        this.logger = Debug.getNamedLogger("jacorb.orb");
    }

    static {
        services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory"};
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private Class implementationClass;

        public Serializable read_value(InputStream inputStream) {
            StreamableValue streamableValue = (StreamableValue)ORB.this.instantiate(this.implementationClass);
            return inputStream.read_value(streamableValue);
        }

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private final org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int n) throws InvalidSlot {
            return this.getTarget().get_slot(n);
        }

        public void set_slot(int n, Any any) throws InvalidSlot {
            this.getTarget().set_slot(n, any);
        }

        PICurrent() {
        }
    }
}

