/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.TimeBase.UtcT;

public class ReplyReceiver
extends ReplyPlaceholder {
    private Delegate delegate = null;
    private ClientInterceptorHandler interceptors = null;
    private ReplyHandler replyHandler = null;
    private String operation;
    private UtcT replyEndTime;
    private Timer timer;
    private boolean retry_on_failure = false;
    private static /* synthetic */ Class class$Lorg$omg$CORBA$portable$InvokeHandler;

    public synchronized void replyReceived(MessageInputStream messageInputStream) {
        if (this.timeoutException) {
            return;
        }
        if (this.timer != null) {
            this.timer.wakeup();
        }
        this.in = messageInputStream;
        this.delegate.replyDone(this);
        if (this.replyHandler != null) {
            this.performCallback((ReplyInputStream)messageInputStream);
        } else {
            this.ready = true;
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void performCallback(ReplyInputStream replyInputStream) {
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject servantObject = delegate.servant_preinvoke(this.replyHandler, this.operation, class$Lorg$omg$CORBA$portable$InvokeHandler != null ? class$Lorg$omg$CORBA$portable$InvokeHandler : (class$Lorg$omg$CORBA$portable$InvokeHandler = ReplyReceiver.class$("org.omg.CORBA.portable.InvokeHandler")));
        try {
            try {
                switch (replyInputStream.getStatus().value()) {
                    case 0: {
                        ((InvokeHandler)servantObject.servant)._invoke(this.operation, replyInputStream, new DummyResponseHandler());
                        break;
                    }
                    case 1: 
                    case 2: {
                        ExceptionHolderImpl exceptionHolderImpl = new ExceptionHolderImpl(replyInputStream);
                        ORB oRB = (ORB)delegate.orb(null);
                        oRB.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
                        CDRInputStream cDRInputStream = new CDRInputStream(oRB, exceptionHolderImpl.marshal());
                        ((InvokeHandler)servantObject.servant)._invoke(this.operation + "_excep", cDRInputStream, new DummyResponseHandler());
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Debug.output(2, "Exception during callback: " + exception.getMessage());
                return;
            }
            {
            }
            java.lang.Object var5_8 = null;
            delegate.servant_postinvoke(this.replyHandler, servantObject);
            return;
        }
        finally {
            java.lang.Object var5_9 = null;
            delegate.servant_postinvoke(this.replyHandler, servantObject);
        }
    }

    private final void performExceptionCallback(ExceptionHolderImpl exceptionHolderImpl) {
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject servantObject = delegate.servant_preinvoke(this.replyHandler, this.operation, class$Lorg$omg$CORBA$portable$InvokeHandler != null ? class$Lorg$omg$CORBA$portable$InvokeHandler : (class$Lorg$omg$CORBA$portable$InvokeHandler = ReplyReceiver.class$("org.omg.CORBA.portable.InvokeHandler")));
        try {
            try {
                ORB oRB = (ORB)delegate.orb(null);
                oRB.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
                CDRInputStream cDRInputStream = new CDRInputStream(oRB, exceptionHolderImpl.marshal());
                ((InvokeHandler)servantObject.servant)._invoke(this.operation + "_excep", cDRInputStream, new DummyResponseHandler());
            }
            catch (Exception exception) {
                Debug.output(2, "Exception during callback: " + exception.getMessage());
                java.lang.Object var5_8 = null;
                delegate.servant_postinvoke(this.replyHandler, servantObject);
            }
            java.lang.Object var5_7 = null;
            delegate.servant_postinvoke(this.replyHandler, servantObject);
        }
        catch (Throwable throwable) {
            java.lang.Object var5_9 = null;
            delegate.servant_postinvoke(this.replyHandler, servantObject);
            throw throwable;
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw cOMM_FAILURE;
            }
        }
        catch (SystemException systemException) {
            this.interceptors.handle_receive_exception(systemException);
            throw systemException;
        }
        catch (RemarshalException remarshalException) {
            this.delegate.waitOnBarrier();
            throw new RemarshalException();
        }
        ReplyInputStream replyInputStream = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 replyStatusType_1_2 = this.delegate.doNotCheckExceptions() ? ReplyStatusType_1_2.NO_EXCEPTION : replyInputStream.getStatus();
        switch (replyStatusType_1_2.value()) {
            case 0: {
                this.interceptors.handle_receive_reply(replyInputStream);
                return replyInputStream;
            }
            case 1: {
                ApplicationException applicationException = this.getApplicationException(replyInputStream);
                this.interceptors.handle_receive_exception(applicationException, replyInputStream);
                throw applicationException;
            }
            case 2: {
                SystemException systemException = SystemExceptionHelper.read(replyInputStream);
                this.interceptors.handle_receive_exception(systemException, replyInputStream);
                throw systemException;
            }
            case 3: 
            case 4: {
                Object object = replyInputStream.read_Object();
                this.interceptors.handle_location_forward(replyInputStream, object);
                this.doRebind(object);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + replyStatusType_1_2.value());
    }

    private final void doRebind(Object object) {
        Set set;
        this.delegate.lockBarrier();
        Set set2 = set = this.delegate.get_pending_replies();
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ReplyPlaceholder replyPlaceholder = (ReplyPlaceholder)iterator.next();
                replyPlaceholder.retry();
            }
        }
        this.delegate.rebind(object);
        this.delegate.openBarrier();
    }

    private final ApplicationException getApplicationException(ReplyInputStream replyInputStream) {
        replyInputStream.mark(0);
        String string = replyInputStream.read_string();
        try {
            replyInputStream.reset();
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
        return new ApplicationException(string, replyInputStream);
    }

    static /* synthetic */ MessageInputStream access$0(ReplyReceiver replyReceiver) {
        return replyReceiver.in;
    }

    static /* synthetic */ boolean access$3(ReplyReceiver replyReceiver) {
        return replyReceiver.timeoutException;
    }

    static /* synthetic */ boolean access$7(ReplyReceiver replyReceiver) {
        return replyReceiver.ready;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ReplyReceiver(Delegate delegate, String string, UtcT utcT, ClientInterceptorHandler clientInterceptorHandler, ReplyHandler replyHandler) {
        this.delegate = delegate;
        this.operation = string;
        this.replyEndTime = utcT;
        this.interceptors = clientInterceptorHandler;
        this.replyHandler = replyHandler;
        if (utcT != null) {
            this.timer = new Timer(utcT);
            this.timer.setName("ReplyReceiver Timer");
            this.timer.start();
        } else {
            this.timer = null;
        }
        this.retry_on_failure = Environment.retryOnFailure();
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }

        DummyResponseHandler() {
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        public Serializable read_value(InputStream inputStream) {
            ExceptionHolderImpl exceptionHolderImpl = new ExceptionHolderImpl();
            exceptionHolderImpl._read(inputStream);
            return exceptionHolderImpl;
        }

        ExceptionHolderFactory() {
        }
    }

    private class Timer
    extends Thread {
        private boolean awakened = false;
        private UtcT endTime;

        public void run() {
            Timer timer = this;
            synchronized (timer) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    long l = Time.millisTo(this.endTime);
                    if (l > 0L) {
                        try {
                            this.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            Debug.output(3, "interrupted while waiting for timeout");
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver replyReceiver = ReplyReceiver.this;
                        synchronized (replyReceiver) {
                            ReplyReceiver.this.timeoutException = true;
                            if (ReplyReceiver.this.replyHandler != null) {
                                ReplyReceiver.this.performExceptionCallback(new ExceptionHolderImpl(new TIMEOUT()));
                            }
                            ReplyReceiver.this.ready = true;
                            ReplyReceiver.this.notifyAll();
                        }
                    }
                }
            }
        }

        public void wakeup() {
            Timer timer = this;
            synchronized (timer) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                this.notifyAll();
            }
        }

        public Timer(UtcT utcT) {
            this.endTime = utcT;
        }
    }
}

