/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import org.jacorb.util.Environment;

public abstract class PortRangeFactory {
    protected int portMin = 0;
    protected int portMax = 0;

    private final int getPortProperty(String string) {
        int n;
        String string2 = Environment.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException("PortRangeFactory: " + string + " property not set");
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("PortRangeFactory: " + string + " invalid port number");
        }
        if (n < 0) {
            n += 65536;
        }
        if (n <= 0 || n > 65535) {
            throw new RuntimeException("PortRangeFactory: " + string + " invalid port number");
        }
        return n;
    }

    public PortRangeFactory(String string, String string2) {
        this.portMin = this.getPortProperty(string);
        this.portMax = this.getPortProperty(string2);
        if (this.portMin >= this.portMax) {
            throw new RuntimeException("PortRangeFactory: minimum port number not less than maximum");
        }
    }
}

