/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.util.Debug;

public class PortRangeServerSocketFactory
extends PortRangeFactory
implements ServerSocketFactory {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        int n3 = this.portMin;
        while (n3 <= this.portMax) {
            try {
                ServerSocket serverSocket = new ServerSocket(n3, n2);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + n3);
                return serverSocket;
            }
            catch (IOException iOException) {
                ++n3;
            }
        }
        Debug.output(2, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        int n3 = this.portMin;
        while (n3 <= this.portMax) {
            try {
                ServerSocket serverSocket = new ServerSocket(n3, n2, inetAddress);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + n3);
                return serverSocket;
            }
            catch (IOException iOException) {
                ++n3;
            }
        }
        Debug.output(2, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        int n2 = this.portMin;
        while (n2 <= this.portMax) {
            try {
                ServerSocket serverSocket = new ServerSocket(n2);
                Debug.output(2, "PortRangeServerSocketFactory: Created server socket at :" + n2);
                return serverSocket;
            }
            catch (IOException iOException) {
                ++n2;
            }
        }
        Debug.output(3, "Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public PortRangeServerSocketFactory() {
        super(MIN_PROP, MAX_PROP);
    }
}

