/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;

public class PortRangeSocketFactory
extends PortRangeFactory
implements SocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        int n2 = this.portMin;
        while (n2 <= this.portMax) {
            try {
                Socket socket = new Socket(string, n, inetAddress, n2);
                Debug.output(2, "PortRangeSocketFactory: Created socket between " + inetAddress.getHostAddress() + ":" + n2 + " and " + string + ":" + n);
                return socket;
            }
            catch (IOException iOException) {
                ++n2;
            }
        }
        Debug.output(2, "Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    public PortRangeSocketFactory() {
        super(MIN_PROP, MAX_PROP);
    }
}

