/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.SelectionStrategy;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class GIOPConnectionManager {
    private List server_giop_connections;
    private int max_server_giop_connections;
    private Class statistics_provider_class;
    private SelectionStrategy selection_strategy;
    private int wait_for_idle_interval;
    private Logger logger;

    public ServerGIOPConnection createServerGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener) {
        List list;
        ServerGIOPConnection serverGIOPConnection;
        if (this.server_giop_connections.size() >= this.max_server_giop_connections) {
            if (this.selection_strategy != null) {
                while (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                    serverGIOPConnection = null;
                    list = this.server_giop_connections;
                    synchronized (list) {
                        serverGIOPConnection = this.selection_strategy.selectForClose(this.server_giop_connections);
                    }
                    if (serverGIOPConnection == null || !serverGIOPConnection.tryClose()) {
                        try {
                            Thread.sleep(this.wait_for_idle_interval);
                        }
                        catch (Exception exception) {
                            Debug.output(1, exception);
                        }
                        continue;
                    }
                    break;
                }
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error("No. of max server giop connections set, but no SelectionStrategy present");
            }
        }
        serverGIOPConnection = new ServerGIOPConnection(profile, connection, requestListener, replyListener, this.getStatisticsProvider(), this);
        list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.add(serverGIOPConnection);
        }
        return serverGIOPConnection;
    }

    public void unregisterServerGIOPConnection(ServerGIOPConnection serverGIOPConnection) {
        List list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.remove(serverGIOPConnection);
        }
    }

    public GIOPConnection createClientGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener) {
        return new ClientGIOPConnection(profile, connection, requestListener, replyListener, null);
    }

    private final StatisticsProvider getStatisticsProvider() {
        StatisticsProvider statisticsProvider = null;
        if (this.statistics_provider_class != null) {
            try {
                statisticsProvider = (StatisticsProvider)this.statistics_provider_class.newInstance();
            }
            catch (Exception exception) {
                Debug.output(1, "ERROR: Unable to create instance from Class >" + this.statistics_provider_class + "<");
            }
        }
        return statisticsProvider;
    }

    public GIOPConnectionManager() {
        block3: {
            String string;
            this.server_giop_connections = null;
            this.max_server_giop_connections = 0;
            this.statistics_provider_class = null;
            this.selection_strategy = null;
            this.wait_for_idle_interval = 0;
            this.logger = Debug.getNamedLogger("jacorb.giop.conn");
            this.server_giop_connections = new LinkedList();
            this.max_server_giop_connections = Environment.getIntPropertyWithDefault("jacorb.connection.max_server_connections", Integer.MAX_VALUE);
            this.selection_strategy = (SelectionStrategy)Environment.getObjectProperty("jacorb.connection.selection_strategy_class");
            this.wait_for_idle_interval = Environment.getIntPropertyWithDefault("jacorb.connection.wait_for_idle_interval", 500);
            if (Environment.hasProperty("jacorb.connection.statistics_provider_class") && (string = Environment.getProperty("jacorb.connection.statistics_provider_class")) != null && string.length() > 0) {
                try {
                    this.statistics_provider_class = Environment.classForName(string);
                }
                catch (Exception exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + exception.getMessage());
                }
            }
        }
    }
}

