/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.GIOP.ReplyStatusType_1_2;

public class NoBiDirClientRequestListener
implements RequestListener {
    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a request on a non-bidir connection");
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a locate request on a non-bidir connection");
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Debug.output(1, "WARNING: Received a cancel request on a non-bidir connection");
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    private final void replyException(byte[] byArray, GIOPConnection gIOPConnection) {
        int n = Messages.getGIOPMinor(byArray);
        ReplyOutputStream replyOutputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n, false);
        SystemExceptionHelper.write(replyOutputStream, new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
        try {
            gIOPConnection.sendReply(replyOutputStream);
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
    }
}

