/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingInputStream;
import org.jacorb.util.Debug;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.GIOP.ReplyHeader_1_2Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.ForwardRequest;

public class ReplyInputStream
extends ServiceContextTransportingInputStream {
    public ReplyHeader_1_2 rep_hdr = null;
    private int body_start;

    public ReplyStatusType_1_2 getStatus() {
        return this.rep_hdr.reply_status;
    }

    public synchronized Exception getException() {
        switch (this.rep_hdr.reply_status.value()) {
            case 1: {
                this.mark(0);
                String string = this.read_string();
                try {
                    this.reset();
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
                return new ApplicationException(string, this);
            }
            case 2: {
                return SystemExceptionHelper.read(this);
            }
            case 3: 
            case 4: {
                return new ForwardRequest(this.read_Object());
            }
        }
        return null;
    }

    public byte[] getBody() {
        int n = this.msg_size - (this.body_start - 12);
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.body_start, byArray, 0, n);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            try {
                this.close();
            }
            catch (IOException iOException) {
                Object var2_2 = null;
                super.finalize();
                return;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public ReplyInputStream(ORB oRB, byte[] byArray) {
        super(oRB, byArray);
        if (Messages.getMsgType(byArray) != 1) {
            throw new MARSHAL("Not a reply!");
        }
        switch (this.giop_minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 replyHeader_1_0 = ReplyHeader_1_0Helper.read(this);
                this.body_start = this.pos;
                this.rep_hdr = new ReplyHeader_1_2(replyHeader_1_0.request_id, ReplyStatusType_1_2.from_int(replyHeader_1_0.reply_status.value()), replyHeader_1_0.service_context);
                break;
            }
            case 2: {
                this.rep_hdr = ReplyHeader_1_2Helper.read(this);
                this.skipHeaderPadding();
                this.body_start = this.pos;
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
            }
        }
    }
}

