/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.jacorb.util.Time;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.PrincipalHelper;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.TimeBase.UtcT;

public class RequestOutputStream
extends ServiceContextTransportingOutputStream {
    private static byte[] principal = new byte[0];
    private static byte[] reserved = new byte[3];
    private int request_id = -1;
    private boolean response_expected = true;
    private short syncScope = (short)2;
    private String operation = null;
    private UtcT requestStartTime = null;
    private UtcT requestEndTime = null;
    private UtcT replyEndTime = null;
    private Request request = null;
    private ClientConnection connection = null;

    public int requestId() {
        return this.request_id;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public short syncScope() {
        return this.syncScope;
    }

    public String operation() {
        return this.operation;
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    private final PolicyValue[] getTimingPolicyValues() {
        ArrayList<PolicyValue> arrayList = new ArrayList<PolicyValue>();
        if (this.requestStartTime != null) {
            arrayList.add(new PolicyValue(27, Time.toCDR(this.requestStartTime)));
        }
        if (this.requestEndTime != null) {
            arrayList.add(new PolicyValue(28, Time.toCDR(this.requestEndTime)));
        }
        if (this.replyEndTime != null) {
            arrayList.add(new PolicyValue(30, Time.toCDR(this.replyEndTime)));
        }
        return arrayList.toArray(new PolicyValue[0]);
    }

    private final ServiceContext createInvocationPolicies() {
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        PolicyValueSeqHelper.write(cDROutputStream, this.getTimingPolicyValues());
        return new ServiceContext(7, cDROutputStream.getBufferCopy());
    }

    public RequestOutputStream(ClientConnection clientConnection, int n, String string, boolean bl, short s, UtcT utcT, UtcT utcT2, UtcT utcT3, byte[] byArray, int n2) {
        this.setGIOPMinor(n2);
        this.request_id = n;
        this.response_expected = bl;
        this.syncScope = s;
        this.operation = string;
        this.connection = clientConnection;
        this.requestStartTime = utcT;
        this.requestEndTime = utcT2;
        this.replyEndTime = utcT3;
        if (utcT != null || utcT2 != null || utcT3 != null) {
            this.addServiceContext(this.createInvocationPolicies());
        }
        this.writeGIOPMsgHeader(0, n2);
        switch (n2) {
            case 0: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(n);
                this.write_boolean(bl);
                this.write_long(byArray.length);
                this.write_octet_array(byArray, 0, byArray.length);
                this.write_string(string);
                PrincipalHelper.write(this, principal);
                break;
            }
            case 1: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(n);
                this.write_boolean(bl);
                this.write_long(byArray.length);
                this.write_octet_array(byArray, 0, byArray.length);
                this.write_string(string);
                PrincipalHelper.write(this, principal);
                break;
            }
            case 2: {
                TargetAddress targetAddress = new TargetAddress();
                targetAddress.object_key(byArray);
                this.write_ulong(n);
                if (bl) {
                    this.write_octet((byte)3);
                } else {
                    switch (s) {
                        case 0: 
                        case 1: {
                            this.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            this.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            this.write_octet((byte)3);
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid SYNC_SCOPE: " + s);
                        }
                    }
                }
                this.write_octet_array(reserved, 0, 3);
                TargetAddressHelper.write(this, targetAddress);
                this.write_string(string);
                ServiceContextListHelper.write(this, Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + n2);
            }
        }
    }
}

