/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ETF.Factories;

public class TransportManager {
    public static SocketFactory socket_factory = null;
    public static SocketFactory ssl_socket_factory = null;
    private ProfileSelector profileSelector = null;
    private Map factoriesMap = null;
    private List factoriesList = null;
    private static /* synthetic */ Class class$Lorg$jacorb$orb$ORB;

    public ProfileSelector getProfileSelector() {
        if (this.profileSelector == null) {
            this.profileSelector = (ProfileSelector)Environment.getObjectProperty("jacorb.transport.client.selector");
            if (this.profileSelector == null) {
                this.profileSelector = new DefaultProfileSelector();
            }
        }
        return this.profileSelector;
    }

    public Factories getFactories(int n) {
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(new Integer(n));
    }

    public List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private final void loadFactories() {
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        List list = Environment.getListProperty("jacorb.transport.factories");
        if (list.isEmpty()) {
            list.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Factories factories = this.instantiateFactories(string);
            this.factoriesMap.put(new Integer(factories.profile_tag()), factories);
            this.factoriesList.add(factories);
        }
    }

    private final Factories instantiateFactories(String string) {
        try {
            Class clazz = Environment.classForName(string);
            return (Factories)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("could not instantiate Factories class " + string + ", exception: " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransportManager(ORB oRB) {
        socket_factory = SocketFactoryManager.getSocketFactory(oRB);
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            String string = Environment.getProperty("jacorb.ssl.socket_factory");
            if (string == null || string.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class clazz = Environment.classForName(string);
                Constructor constructor = clazz.getConstructor(class$Lorg$jacorb$orb$ORB != null ? class$Lorg$jacorb$orb$ORB : (class$Lorg$jacorb$orb$ORB = TransportManager.class$("org.jacorb.orb.ORB")));
                ssl_socket_factory = (SocketFactory)constructor.newInstance(oRB);
            }
            catch (Exception exception) {
                Debug.output(2, exception.getMessage());
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instanciated (see trace)!");
            }
        }
    }
}

