/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF._ConnectionLocalBase;

public abstract class IIOPConnection
extends _ConnectionLocalBase {
    protected boolean connected = false;
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;
    private ByteArrayOutputStream b_out = null;
    private boolean dump_incoming = false;
    protected String connection_info;
    protected Socket socket;
    private int finalTimeout = 20000;
    private Logger logger = Debug.getNamedLogger("jacorb.iiop.conn");

    public void read(BufferHolder bufferHolder, int n, int n2, int n3, long l) {
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            try {
                n5 = this.in_stream.read(bufferHolder.value, n + n4, n2 - n4);
            }
            catch (InterruptedIOException interruptedIOException) {
                int n6 = 0;
                try {
                    n6 = this.socket.getSoTimeout();
                }
                catch (SocketException socketException) {
                    throw this.to_COMM_FAILURE(socketException);
                }
                if (n6 != 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Socket timeout (timeout period: " + n6 + ")");
                    }
                    throw new TIMEOUT();
                }
                throw new TRANSIENT("Interrupted I/O: " + interruptedIOException);
            }
            catch (IOException iOException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed");
                }
                throw this.to_COMM_FAILURE(iOException);
            }
            if (n5 < 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed");
                }
                throw new COMM_FAILURE("read() did not return any data");
            }
            n4 += n5;
        }
    }

    public void write(boolean bl, boolean bl2, byte[] byArray, int n, int n2, long l) {
        try {
            this.out_stream.write(byArray, n, n2);
            if (this.b_out != null) {
                this.b_out.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public void flush() {
        try {
            if (this.b_out != null) {
                byte[] byArray = this.b_out.toByteArray();
                Debug.output(1, "sendMessages()", byArray);
                this.b_out.reset();
            }
            this.out_stream.flush();
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public synchronized boolean is_connected() {
        return this.connected;
    }

    public void turnOnFinalTimeout() {
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(this.finalTimeout);
            }
            catch (SocketException socketException) {
                Debug.output(2, socketException);
            }
        }
    }

    public abstract boolean isSSL();

    protected COMM_FAILURE to_COMM_FAILURE(IOException iOException) {
        return new COMM_FAILURE("IOException: " + iOException.toString());
    }

    public boolean is_data_available() {
        try {
            return this.in_stream.available() > 0;
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public boolean wait_next_data(long l) {
        throw new NO_IMPLEMENT();
    }

    public boolean supports_callback() {
        return true;
    }

    public boolean use_handle_time_out() {
        return false;
    }

    public IIOPConnection(IIOPConnection iIOPConnection) {
        this.in_stream = iIOPConnection.in_stream;
        this.out_stream = iIOPConnection.out_stream;
        this.b_out = iIOPConnection.b_out;
        this.dump_incoming = iIOPConnection.dump_incoming;
        this.connection_info = iIOPConnection.connection_info;
        this.finalTimeout = iIOPConnection.finalTimeout;
    }

    public IIOPConnection() {
        String string = Environment.getProperty("jacorb.debug.dump_outgoing_messages", "off");
        if ("on".equals(string)) {
            this.b_out = new ByteArrayOutputStream();
        }
        this.finalTimeout = Environment.getIntPropertyWithDefault("jacorb.connection.timeout_after_closeconnection", 20000);
    }
}

