/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ETF.Profile;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends _ProfileLocalBase
implements Cloneable {
    private Version version = null;
    private IIOPAddress primaryAddress = null;
    private byte[] objectKey = null;
    private TaggedComponentList components = null;
    private static /* synthetic */ Class class$Lorg$jacorb$orb$IIOPAddress;
    private static /* synthetic */ Class class$Lorg$omg$SSLIOP$SSLHelper;

    private final void decode_corbaloc(String string) {
        String string2 = "127.0.0.1";
        int n = 2809;
        int n2 = 1;
        int n3 = 2;
        String string3 = "Illegal IIOP protocol format in object address format: " + string;
        int n4 = string.indexOf(58);
        String string4 = "";
        if (n4 != 0) {
            string4 = string.substring(0, n4);
        }
        if (n4 + 1 == string.length()) {
            throw new IllegalArgumentException(string3);
        }
        if ((n4 = (string = string.substring(n4 + 1)).indexOf(64)) > -1) {
            String string5 = string.substring(0, n4);
            string = string.substring(n4 + 1);
            n4 = string5.indexOf(46);
            if (n4 != -1) {
                try {
                    n2 = Integer.parseInt(string5.substring(0, n4));
                    n3 = Integer.parseInt(string5.substring(n4 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(string3);
                }
            }
        }
        this.version = new Version((byte)n2, (byte)n3);
        n4 = string.indexOf(58);
        if (n4 != -1) {
            try {
                n = (short)Integer.parseInt(string.substring(n4 + 1));
                string2 = string.substring(0, n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string3);
            }
        }
        this.primaryAddress = new IIOPAddress(string2, n);
        this.decode_extensions(string4.toLowerCase());
    }

    private final void decode_extensions(String string) {
        this.components = new TaggedComponentList();
        if (string.equals("ssliop")) {
            SSL sSL = new SSL();
            sSL.port = (short)this.primaryAddress.getPort();
            String string2 = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            sSL.target_supports = this.get_ssl_options(string2);
            string2 = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            sSL.target_requires = this.get_ssl_options(string2);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            SSLHelper.write(cDROutputStream, sSL);
            this.components.addComponent(new TaggedComponent(20, cDROutputStream.getBufferCopy()));
        }
    }

    private final short get_ssl_options(String string) {
        String string2 = Environment.getProperty(string);
        short s = 32;
        if (string2 != null && !string2.equals("")) {
            try {
                s = (short)Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.output(0, "WARNING: Invalid hex property >>" + string2 + "<<");
                Debug.output(0, "Please check property \"" + string + "\"");
            }
        }
        return s;
    }

    public void marshal(TaggedProfileHolder taggedProfileHolder, TaggedComponentSeqHolder taggedComponentSeqHolder) {
        TaggedComponent[] taggedComponentArray = null;
        CDROutputStream cDROutputStream = null;
        if (taggedComponentSeqHolder == null) {
            taggedComponentSeqHolder = new TaggedComponentSeqHolder(new TaggedComponent[0]);
        }
        switch (this.version.minor) {
            case 1: 
            case 2: {
                taggedComponentArray = new TaggedComponent[this.components.size() + taggedComponentSeqHolder.value.length];
                System.arraycopy(this.components.asArray(), 0, taggedComponentArray, 0, this.components.size());
                System.arraycopy(taggedComponentSeqHolder.value, 0, taggedComponentArray, this.components.size(), taggedComponentSeqHolder.value.length);
                ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1(new org.omg.IIOP.Version(this.version.major, this.version.minor), Environment.isPropertyOn("jacorb.dns.enable") ? this.primaryAddress.getHostname() : this.primaryAddress.getIP(), (short)this.primaryAddress.getPort(), this.objectKey, taggedComponentArray);
                cDROutputStream = new CDROutputStream();
                cDROutputStream.beginEncapsulatedArray();
                ProfileBody_1_1Helper.write(cDROutputStream, profileBody_1_1);
                taggedProfileHolder.value = new TaggedProfile(0, cDROutputStream.getBufferCopy());
                break;
            }
            case 0: {
                ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(new org.omg.IIOP.Version(this.version.major, this.version.minor), Environment.isPropertyOn("jacorb.dns.enable") ? this.primaryAddress.getHostname() : this.primaryAddress.getIP(), (short)this.primaryAddress.getPort(), this.objectKey);
                cDROutputStream = new CDROutputStream();
                cDROutputStream.beginEncapsulatedArray();
                ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
                taggedProfileHolder.value = new TaggedProfile(0, cDROutputStream.getBufferCopy());
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("error cloning profile: " + cloneNotSupportedException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile iIOPProfile = (IIOPProfile)super.clone();
        iIOPProfile.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            iIOPProfile.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, iIOPProfile.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            iIOPProfile.components = (TaggedComponentList)this.components.clone();
        }
        return iIOPProfile;
    }

    public boolean is_match(Profile profile) {
        if (profile instanceof IIOPProfile) {
            IIOPProfile iIOPProfile = (IIOPProfile)profile;
            return this.primaryAddress.equals(iIOPProfile.primaryAddress) && this.getAlternateAddresses().equals(iIOPProfile.getAlternateAddresses());
        }
        return false;
    }

    public Version version() {
        return this.version;
    }

    public void set_object_key(byte[] byArray) {
        this.objectKey = byArray;
    }

    public int tag() {
        return 0;
    }

    public IIOPAddress getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(String string, int n) {
        if (string != null) {
            this.primaryAddress = new IIOPAddress(string, n != -1 ? n : this.primaryAddress.getPort());
        } else if (n != -1) {
            this.primaryAddress = new IIOPAddress(this.primaryAddress.getIP(), n);
        }
    }

    public List getAlternateAddresses() {
        return this.components.getComponents(3, class$Lorg$jacorb$orb$IIOPAddress != null ? class$Lorg$jacorb$orb$IIOPAddress : (class$Lorg$jacorb$orb$IIOPAddress = IIOPProfile.class$("org.jacorb.orb.IIOPAddress")));
    }

    public byte[] get_object_key() {
        return this.objectKey;
    }

    public SSL getSSL() {
        return (SSL)this.components.getComponent(20, class$Lorg$omg$SSLIOP$SSLHelper != null ? class$Lorg$omg$SSLIOP$SSLHelper : (class$Lorg$omg$SSLIOP$SSLHelper = IIOPProfile.class$("org.omg.SSLIOP.SSLHelper")));
    }

    public int getSSLPort() {
        SSL sSL = this.getSSL();
        if (sSL == null) {
            return -1;
        }
        int n = sSL.port;
        if (n < 0) {
            n += 65536;
        }
        return n;
    }

    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int n, Class clazz) {
        return this.components.getComponent(n, clazz);
    }

    public void addComponent(int n, Object object, Class clazz) {
        this.components.addComponent(n, object, clazz);
    }

    public void addComponent(int n, byte[] byArray) {
        this.components.addComponent(n, byArray);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
        this.marshal(taggedProfileHolder, null);
        return taggedProfileHolder.value;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile iIOPProfile = new IIOPProfile(this.primaryAddress, this.objectKey);
        iIOPProfile.version.minor = 0;
        return iIOPProfile;
    }

    public boolean equals(Object object) {
        if (object instanceof Profile) {
            return this.primaryAddress.equals(((IIOPProfile)object).primaryAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public IIOPProfile(byte[] byArray) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        cDRInputStream.openEncapsulatedArray();
        org.omg.IIOP.Version version = VersionHelper.read(cDRInputStream);
        this.version = new Version(version.major, version.minor);
        this.primaryAddress = IIOPAddress.read(cDRInputStream);
        int n = cDRInputStream.read_ulong();
        this.objectKey = new byte[n];
        cDRInputStream.read_octet_array(this.objectKey, 0, n);
        this.components = this.version.minor > 0 ? new TaggedComponentList(cDRInputStream) : new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray) {
        this.version = new Version(1, 2);
        this.primaryAddress = iIOPAddress;
        this.objectKey = byArray;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray, int n) {
        this.version = new Version(1, (byte)n);
        this.primaryAddress = iIOPAddress;
        this.objectKey = byArray;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(String string) {
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        try {
            this.decode_corbaloc(string);
        }
        catch (Exception exception) {
            Debug.output(1, "could not create new IIOPProfile");
        }
    }
}

