/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.util.Debug;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    private boolean is_ssl;
    private IIOPProfile profile;

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
            }
            catch (IOException iOException) {
                throw this.to_COMM_FAILURE(iOException);
            }
            this.socket = null;
            this.connected = false;
            Debug.output(2, "Closed server-side transport to " + this.connection_info);
        }
    }

    public void connect(Profile profile, long l) {
    }

    public boolean isSSL() {
        return this.is_ssl;
    }

    public Profile get_server_profile() {
        return this.profile;
    }

    public ServerIIOPConnection(Socket socket, boolean bl) throws IOException {
        this.socket = socket;
        this.is_ssl = bl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
        IIOPAddress iIOPAddress = new IIOPAddress(socket.getInetAddress().getHostAddress(), socket.getPort());
        this.profile = new IIOPProfile(iIOPAddress, null);
        this.connection_info = iIOPAddress.toString();
        this.connected = true;
        Debug.output(2, "Opened new server-side TCP/IP transport to " + this.connection_info);
    }
}

