/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.policies.PolicyUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA._PolicyManagerLocalBase;

public class PolicyManager
extends _PolicyManagerLocalBase {
    private ORB orb;
    private Map policy_overrides = null;
    private Logger logger = Debug.getNamedLogger("jacorb.orb.policies");

    public synchronized Policy[] get_policy_overrides(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        if (nArray.length == 0) {
            return this.policy_overrides.values().toArray(new Policy[0]);
        }
        Vector<Policy> vector = new Vector<Policy>();
        int n = 0;
        while (n < nArray.length) {
            Policy policy = (Policy)this.policy_overrides.get(new Integer(nArray[n]));
            if (policy != null) {
                vector.add(policy);
            }
            ++n;
        }
        Policy[] policyArray = vector.toArray(new Policy[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get_policy_overrides returns " + policyArray.length + " policies");
        }
        return policyArray;
    }

    public synchronized void set_policy_overrides(Policy[] policyArray, SetOverrideType setOverrideType) throws InvalidPolicies {
        if (policyArray == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        HashMap<Integer, Policy> hashMap = new HashMap<Integer, Policy>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < policyArray.length) {
            if (!PolicyUtil.isInvocationPolicy(policyArray[n].policy_type())) {
                throw new NO_PERMISSION("Not an invocation policy, type " + policyArray[n].policy_type());
            }
            Integer n2 = new Integer(policyArray[n].policy_type());
            if (hashMap.put(n2, policyArray[n]) != null) {
                throw new BAD_PARAM("Multiple policies of type " + policyArray[n].policy_type(), 30, CompletionStatus.COMPLETED_NO);
            }
            stringBuffer.append(" " + policyArray[n].policy_type());
            ++n;
        }
        if (setOverrideType == SetOverrideType.SET_OVERRIDE) {
            PolicyUtil.checkValidity(hashMap);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SET_OVERRIDE, types: " + stringBuffer.toString());
            }
            this.policy_overrides = hashMap;
        } else if (setOverrideType == SetOverrideType.ADD_OVERRIDE) {
            HashMap<Integer, Policy> hashMap2 = new HashMap<Integer, Policy>();
            hashMap2.putAll(hashMap);
            PolicyUtil.checkValidity(hashMap2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ADD_OVERRIDE, types: " + stringBuffer.toString());
            }
            this.policy_overrides = hashMap2;
        }
    }

    public PolicyManager(ORB oRB) {
        this.orb = oRB;
        this.policy_overrides = new HashMap();
    }
}

