/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.util.Debug;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private static ThreadLocal piCurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);
    private Interceptor[] client_req_interceptors = null;
    private Interceptor[] server_req_interceptors = null;
    private Interceptor[] ior_interceptors = null;
    private ORB orb = null;
    private int current_slots = 0;
    private Logger logger = Debug.getNamedLogger("jacorb.orb.interceptors");

    public Current getCurrent() {
        Current current = (Current)piCurrent.get();
        if (current == null) {
            current = this.getEmptyCurrent();
            piCurrent.set(current);
        }
        return current;
    }

    public void setTSCurrent(Current current) {
        piCurrent.set(current);
    }

    public void removeTSCurrent() {
        piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.ior_interceptors);
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int n;
        if (this.hasClientRequestInterceptors()) {
            n = 0;
            while (n < this.client_req_interceptors.length) {
                this.client_req_interceptors[n].destroy();
                ++n;
            }
        }
        if (this.hasServerRequestInterceptors()) {
            n = 0;
            while (n < this.server_req_interceptors.length) {
                this.server_req_interceptors[n].destroy();
                ++n;
            }
        }
        if (this.hasIORInterceptors()) {
            n = 0;
            while (n < this.ior_interceptors.length) {
                this.ior_interceptors[n].destroy();
                ++n;
            }
        }
    }

    public InterceptorManager(Vector vector, Vector vector2, Vector vector3, int n, ORB oRB) {
        int n2;
        int n3;
        String string;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + vector2.size() + " SIs, " + vector.size() + " CIs and " + vector3.size() + " IORIs");
        }
        this.client_req_interceptors = new ClientRequestInterceptor[vector.size()];
        int n4 = 0;
        while (n4 < this.client_req_interceptors.length) {
            string = ((ClientRequestInterceptor)vector.elementAt(0)).name();
            n3 = 0;
            n2 = 1;
            while (n2 < vector.size()) {
                if (string.compareTo(((ClientRequestInterceptor)vector.elementAt(n2)).name()) > 0) {
                    string = ((ClientRequestInterceptor)vector.elementAt(n2)).name();
                    n3 = n2;
                }
                ++n2;
            }
            this.client_req_interceptors[n4] = (ClientRequestInterceptor)vector.elementAt(n3);
            vector.removeElementAt(n3);
            ++n4;
        }
        this.server_req_interceptors = new ServerRequestInterceptor[vector2.size()];
        n4 = 0;
        while (n4 < this.server_req_interceptors.length) {
            string = ((ServerRequestInterceptor)vector2.elementAt(0)).name();
            n3 = 0;
            n2 = 1;
            while (n2 < vector2.size()) {
                if (string.compareTo(((ServerRequestInterceptor)vector2.elementAt(n2)).name()) > 0) {
                    string = ((ServerRequestInterceptor)vector2.elementAt(n2)).name();
                    n3 = n2;
                }
                ++n2;
            }
            this.server_req_interceptors[n4] = (ServerRequestInterceptor)vector2.elementAt(n3);
            vector2.removeElementAt(n3);
            ++n4;
        }
        this.ior_interceptors = new IORInterceptor[vector3.size()];
        n4 = 0;
        while (n4 < this.ior_interceptors.length) {
            string = ((IORInterceptor)vector3.elementAt(0)).name();
            n3 = 0;
            n2 = 1;
            while (n2 < vector3.size()) {
                if (string.compareTo(((IORInterceptor)vector3.elementAt(n2)).name()) > 0) {
                    string = ((IORInterceptor)vector3.elementAt(n2)).name();
                    n3 = n2;
                }
                ++n2;
            }
            this.ior_interceptors[n4] = (IORInterceptor)vector3.elementAt(n3);
            vector3.removeElementAt(n3);
            ++n4;
        }
        this.orb = oRB;
        this.current_slots = n;
    }
}

