/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class CorbaLoc {
    private ORB orb;
    private String keyString;
    private byte[] key;
    private String bodyString;
    private boolean is_rir;
    public Profile[] profileList;

    public boolean rir() {
        return this.is_rir;
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    public String body() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bodyString);
        if (this.keyString != null) {
            stringBuffer.append("/" + this.keyString);
        }
        return stringBuffer.toString();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void defaultKeyString(String string) {
        if (this.keyString != null) {
            throw new RuntimeException("KeyString not empty, cannot default to " + string);
        }
        this.keyString = string;
    }

    public String toCorbaName(String string) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (string != null && string.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + string;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    private final void parse(String string) {
        String string2;
        if (string == null || !string.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        if (string.indexOf(47) == -1) {
            string2 = string.substring(string.indexOf(58) + 1);
            if (string.startsWith("corbaloc:rir:")) {
                this.is_rir = true;
                this.keyString = "NameService";
            } else {
                this.keyString = null;
            }
            this.key = new byte[0];
        } else {
            string2 = string.substring(string.indexOf(58) + 1, string.indexOf(47));
            this.keyString = string.substring(string.indexOf(47) + 1);
            this.key = CorbaLoc.parseKey(this.keyString);
        }
        if (string2.indexOf(44) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            this.profileList = new Profile[stringTokenizer.countTokens()];
            int n = 0;
            int n2 = 0;
            while (n2 < this.profileList.length) {
                Profile profile = this.parseAddress(stringTokenizer.nextToken());
                if (profile != null) {
                    this.profileList[n] = profile;
                    ++n;
                }
                ++n2;
            }
            while (n < this.profileList.length) {
                this.profileList[n] = null;
                ++n;
            }
        } else {
            this.profileList = new Profile[]{this.parseAddress(string2)};
        }
        this.bodyString = string2;
    }

    private final Profile parseAddress(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + string);
        }
        if (string.equals("rir:")) {
            this.is_rir = true;
            return null;
        }
        Profile profile = null;
        if (this.orb == null && (n == 0 || string.startsWith("iiop:") || string.startsWith("ssliop:"))) {
            profile = new IIOPProfile(string);
        } else if (this.orb != null) {
            String string2 = string.substring(0, n);
            List list = this.orb.getTransportManager().getFactoriesList();
            Iterator iterator = list.iterator();
            while (profile == null && iterator.hasNext()) {
                Factories factories = (Factories)iterator.next();
                profile = factories.decode_corbaloc(string);
            }
        }
        if (profile == null) {
            throw new IllegalArgumentException("Unknown protocol in object address format: " + string);
        }
        return profile;
    }

    private static final boolean legalChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == ';' || c == '/' || c == ':' || c == '?' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '-' || c == '(' || c == ')';
    }

    private static final byte hexValue(char c) {
        return (byte)(c >= 'a' ? 10 + c - 97 : (c >= 'A' ? 10 + c - 65 : c - 48));
    }

    private static final char hexDigit(byte by) {
        if ((by & 0xF0) != 0) {
            throw new IllegalArgumentException("Hex digit out of range " + by);
        }
        return (char)(by < 10 ? 48 + (char)by : 65 + (char)by - 10);
    }

    private static final boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] parseKey(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (!CorbaLoc.legalChar(cArray[n2])) {
                if (cArray[n2] != '%') throw new IllegalArgumentException("URL character out of range: " + cArray[n2]);
                if (!CorbaLoc.isHex(cArray[n2 + 1]) || !CorbaLoc.isHex(cArray[n2 + 2])) throw new IllegalArgumentException("Illegal escape in URL character");
                n -= 2;
                n2 += 2;
            }
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (CorbaLoc.legalChar(cArray[n3])) {
                byArray[n4] = (byte)cArray[n3++];
            } else {
                byArray[n4] = (byte)(CorbaLoc.hexValue(cArray[n3 + 1]) << 4 | CorbaLoc.hexValue(cArray[n3 + 2]));
                n3 += 3;
            }
            ++n4;
        }
        return byArray;
    }

    public static String parseKey(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (!CorbaLoc.legalChar((char)byArray[n])) {
                stringBuffer.append('%');
                stringBuffer.append(CorbaLoc.hexDigit((byte)((byArray[n] & 0xFF) >> 4)));
                stringBuffer.append(CorbaLoc.hexDigit((byte)(byArray[n] & 0xF)));
            } else {
                stringBuffer.append((char)byArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        ORB oRB = (ORB)org.omg.CORBA.ORB.init(stringArray2, null);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(new CorbaLoc(oRB, stringArray[n]).toString());
            ++n;
        }
    }

    public CorbaLoc(ORB oRB, String string) {
        this.orb = oRB;
        this.is_rir = false;
        this.parse(string);
    }
}

