/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.RequestQueue;
import org.jacorb.poa.except.CompletionRequestedException;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.except.ShutdownInProgressException;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Environment;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;

public final class RequestController
extends Thread {
    private static RPPoolManager singletonPoolManager;
    private static int count;
    private POA poa;
    private ORB orb;
    private RequestQueue requestQueue;
    private AOM aom;
    private RPPoolManager poolManager;
    private int localRequests = 0;
    private Logger logger;
    private Hashtable activeRequestTable;
    private Vector deactivationList = new Vector();
    private boolean terminate;
    private boolean waitForCompletionCalled;
    private boolean waitForShutdownCalled;
    private Object queueLog = new Object();
    private String priorityProp = Environment.getProperty("jacorb.poa.thread_priority");
    private int threadPriority = 10;

    final void clearUpPool() {
        this.getPoolManager().destroy();
    }

    final void clearUpQueue(SystemException systemException) {
        ServerRequest serverRequest;
        while ((serverRequest = this.requestQueue.removeLast()) != null) {
            this.rejectRequest(serverRequest, systemException);
        }
    }

    final void continueToWork() {
        Object object = this.queueLog;
        synchronized (object) {
            this.queueLog.notifyAll();
        }
    }

    final synchronized void end() {
        this.terminate = true;
        this.continueToWork();
    }

    final synchronized void freeObject(byte[] byArray) {
        this.deactivationList.removeElement(new ByteArrayKey(byArray));
    }

    final AOM getAOM() {
        return this.aom;
    }

    final Logger getLogger() {
        return this.logger;
    }

    final ORB getORB() {
        return this.orb;
    }

    final POA getPOA() {
        return this.poa;
    }

    final RPPoolManager getPoolManager() {
        if (this.poolManager == null) {
            if (this.poa.isSingleThreadModel()) {
                if (singletonPoolManager == null) {
                    singletonPoolManager = new RPPoolManager(this.orb.getPOACurrent(), 1, 1);
                }
                this.poolManager = singletonPoolManager;
            } else {
                this.poolManager = new RPPoolManager(this.orb.getPOACurrent(), Environment.threadPoolMin(), Environment.threadPoolMax());
            }
        }
        return this.poolManager;
    }

    final RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    final boolean isDeactivating(ByteArrayKey byteArrayKey) {
        return this.deactivationList.contains(byteArrayKey);
    }

    private final void processRequest(ServerRequest serverRequest) throws ShutdownInProgressException, CompletionRequestedException {
        Servant servant = null;
        ServantManager servantManager = null;
        boolean bl = false;
        ByteArrayKey byteArrayKey = new ByteArrayKey(serverRequest.objectId());
        RequestController requestController = this;
        synchronized (requestController) {
            if (this.waitForCompletionCalled) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request because waitForCompletion was called");
                }
                throw new CompletionRequestedException();
            }
            if (this.waitForShutdownCalled) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request because POA shutdown in progress");
                }
                throw new ShutdownInProgressException();
            }
            if (this.aom != null && this.aom.isDeactivating(byteArrayKey) || this.deactivationList.contains(byteArrayKey)) {
                if (!this.poa.isUseServantManager() && !this.poa.isUseDefaultServant()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request, because object is already in the deactivation process");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
                bl = true;
            }
            if (!bl && this.poa.isRetain()) {
                servant = this.aom.getServant(serverRequest.objectId());
            }
            if (servant == null) {
                if (this.poa.isUseDefaultServant()) {
                    servant = this.poa.defaultServant;
                    if (servant == null) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request because default servant is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else if (this.poa.isUseServantManager()) {
                    servantManager = this.poa.servantManager;
                    if (servantManager == null) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request because servant manager is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " cannot process request, because object doesn't exist");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
            }
            this.activeRequestTable.put(serverRequest, byteArrayKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " trying to get a RequestProcessor");
        }
        RequestProcessor requestProcessor = this.getPoolManager().getProcessor();
        requestProcessor.init(this, serverRequest, servant, servantManager);
        requestProcessor.begin();
    }

    final void queueRequest(ServerRequest serverRequest) throws ResourceLimitReachedException {
        this.requestQueue.add(serverRequest);
    }

    final void rejectRequest(ServerRequest serverRequest, SystemException systemException) {
        if (systemException != null) {
            serverRequest.setSystemException(systemException);
        }
        this.orb.getBasicAdapter().return_result(serverRequest);
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " request rejected with exception: " + systemException.getMessage());
        }
    }

    final synchronized void resetPreviousCompletionCall() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reset a previous completion call");
        }
        this.waitForCompletionCalled = false;
        this.notifyAll();
    }

    final void returnResult(ServerRequest serverRequest) {
        this.orb.getBasicAdapter().return_result(serverRequest);
    }

    final synchronized void finish(ServerRequest serverRequest) {
        this.activeRequestTable.remove(serverRequest);
        this.notifyAll();
    }

    public final void run() {
        OBJ_ADAPTER oBJ_ADAPTER = new OBJ_ADAPTER("connection closed: adapter inactive");
        TRANSIENT tRANSIENT = new TRANSIENT();
        while (!this.terminate) {
            ServerRequest serverRequest;
            State state = this.poa.getState();
            if (POAUtil.isActive(state)) {
                serverRequest = this.requestQueue.getFirst();
                if (serverRequest != null) {
                    if (serverRequest.remainingPOAName() != null) {
                        this.orb.getBasicAdapter().deliverRequest(serverRequest, this.poa);
                        this.requestQueue.removeFirst();
                        continue;
                    }
                    try {
                        this.processRequest(serverRequest);
                        this.requestQueue.removeFirst();
                    }
                    catch (CompletionRequestedException completionRequestedException) {
                    }
                    catch (ShutdownInProgressException shutdownInProgressException) {
                        this.waitForQueue();
                    }
                    catch (OBJ_ADAPTER oBJ_ADAPTER2) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(serverRequest, oBJ_ADAPTER2);
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(serverRequest, oBJECT_NOT_EXIST);
                    }
                    continue;
                }
            } else if (!this.waitForShutdownCalled && (POAUtil.isDiscarding(state) || POAUtil.isInactive(state)) && (serverRequest = this.requestQueue.removeLast()) != null) {
                if (POAUtil.isDiscarding(state)) {
                    this.rejectRequest(serverRequest, tRANSIENT);
                    continue;
                }
                this.rejectRequest(serverRequest, oBJ_ADAPTER);
                continue;
            }
            this.waitForQueue();
        }
    }

    final synchronized void waitForCompletion() {
        this.waitForCompletionCalled = true;
        while (this.waitForCompletionCalled && !this.activeRequestTable.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("somebody waits for completion and there are active processors");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    final synchronized void waitForObjectCompletion(byte[] byArray) {
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        while (this.activeRequestTable.contains(byteArrayKey)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(POAUtil.convert(byArray) + "all active processors for this object have finished");
        }
        this.deactivationList.addElement(byteArrayKey);
    }

    private final void waitForQueue() {
        Object object = this.queueLog;
        synchronized (object) {
            if ((this.requestQueue.isEmpty() || this.poa.isHolding() || this.waitForShutdownCalled) && !this.terminate) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("RequestController waits for queue");
                    }
                    this.queueLog.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    final synchronized void waitForShutdown() {
        this.waitForShutdownCalled = true;
        while (this.waitForShutdownCalled && !this.activeRequestTable.isEmpty() || this.localRequests != 0) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("somebody waits for shutdown and there are active processors");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    final synchronized void addLocalRequest() {
        ++this.localRequests;
    }

    final synchronized void removeLocalRequest() {
        --this.localRequests;
        this.notifyAll();
    }

    private RequestController() {
    }

    RequestController(POA pOA, ORB oRB, AOM aOM, Logger logger) {
        super("RequestController-" + ++count);
        this.poa = pOA;
        this.aom = aOM;
        this.orb = oRB;
        this.logger = logger;
        this.requestQueue = new RequestQueue(this, this.logger);
        this.activeRequestTable = this.poa.isSingleThreadModel() ? new Hashtable(1) : new Hashtable(Environment.threadPoolMax());
        this.getPoolManager();
        if (this.priorityProp != null) {
            try {
                this.threadPriority = Integer.parseInt(this.priorityProp);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error("ERROR: Can't create int from >" + this.priorityProp + "<\n" + "Please check property \"jacorb.poa.thread_priority\"");
            }
        }
        if (this.threadPriority < 1) {
            this.threadPriority = 1;
        } else if (this.threadPriority > 10) {
            this.threadPriority = 10;
        }
        this.setPriority(this.threadPriority);
        this.setDaemon(true);
        this.start();
    }

    static {
        count = 0;
    }
}

