/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.StringPair;
import org.jacorb.util.Environment;

public class RequestQueue {
    private RequestQueueListener queueListener;
    private RequestController controller;
    private Logger logger;
    private List queue = new ArrayList(10);

    protected synchronized void add(ServerRequest serverRequest) throws ResourceLimitReachedException {
        if (this.queue.size() >= Environment.queueMax()) {
            if (Environment.queueWait()) {
                while (this.queue.size() > Environment.queueMin()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else {
                throw new ResourceLimitReachedException();
            }
        }
        this.queue.add(serverRequest);
        if (this.queue.size() == 1) {
            this.controller.continueToWork();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " is queued (queue size: " + this.queue.size() + ")");
        }
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(serverRequest, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.queueListener = EventMulticaster.add(this.queueListener, requestQueueListener);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.queue.size()];
        Iterator iterator = this.queue.iterator();
        int n = 0;
        while (n < stringPairArray.length) {
            ServerRequest serverRequest = (ServerRequest)iterator.next();
            stringPairArray[n] = new StringPair(serverRequest.requestId() + "", new String(serverRequest.objectId()));
            ++n;
        }
        return stringPairArray;
    }

    protected synchronized ServerRequest getElementAndRemove(int n) {
        if (!this.queue.isEmpty()) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                ServerRequest serverRequest = (ServerRequest)iterator.next();
                if (serverRequest.requestId() != n) continue;
                iterator.remove();
                this.notifyAll();
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
                }
                return serverRequest;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        if (!this.queue.isEmpty()) {
            return (ServerRequest)this.queue.get(0);
        }
        return null;
    }

    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        if (!this.queue.isEmpty()) {
            ServerRequest serverRequest = (ServerRequest)this.queue.get(0);
            this.queue.remove(0);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        if (!this.queue.isEmpty()) {
            int n = this.queue.size() - 1;
            ServerRequest serverRequest = (ServerRequest)this.queue.get(n);
            this.queue.remove(n);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(serverRequest, this.queue.size());
            }
            return serverRequest;
        }
        return null;
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener requestQueueListener) {
        this.queueListener = EventMulticaster.remove(this.queueListener, requestQueueListener);
    }

    protected int size() {
        return this.queue.size();
    }

    private RequestQueue() {
    }

    protected RequestQueue(RequestController requestController, Logger logger) {
        this.controller = requestController;
        this.logger = logger;
    }
}

