/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.beans;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class FillLevelCanvas
extends Canvas {
    private Graphics buf = null;
    private Image img = null;
    private Color color1 = Color.orange;
    private Color color2 = Color.red;
    private int width = 0;
    private int height = 0;
    private int max = 0;
    private int avg = 0;
    private int min = 0;
    private int cur = 0;
    private int yAvg = 0;
    private int yCur = 0;
    private boolean useAvg;

    public int getYAvg() {
        if (this.useAvg) {
            return this.yAvg;
        }
        return 0;
    }

    private final void handleException(Throwable throwable) {
    }

    public void init(int n, int n2, int n3, Color color, Color color2, boolean bl) {
        this.min = n;
        this.avg = n2;
        this.max = n3;
        this.useAvg = bl;
        this.yCompute();
        if (color != null) {
            this.color1 = color;
        }
        if (color2 != null) {
            this.color2 = color2;
        }
    }

    private final void initialize() {
        this.setName("FillLevelCanvas");
        this.setBackground(Color.white);
        this.setSize(15, 100);
        this.width = this.getBounds().width;
        this.height = this.getBounds().height;
    }

    public static void main(String[] stringArray) {
        try {
            Frame frame;
            Serializable serializable;
            try {
                serializable = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)((Class)serializable).newInstance();
            }
            catch (Throwable throwable) {
                frame = new Frame();
            }
            serializable = new FillLevelCanvas();
            frame.add("Center", (Component)serializable);
            ((Component)frame).setSize(((Component)serializable).getSize());
            ((Component)frame).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of org.jacorb.poa.gui.FillLevelCanvas");
            throwable.printStackTrace(System.out);
        }
    }

    public void paint(Graphics graphics) {
        if (this.buf == null) {
            this.img = this.createImage(this.getBounds().width, this.getBounds().height);
            this.buf = this.img.getGraphics();
        } else {
            this.buf.setColor(this.getBackground());
            this.buf.fillRect(0, 0, this.width, this.height);
            this.buf.setColor(this.getForeground());
        }
        this.paintUnbuffered(this.buf);
        graphics.drawImage(this.img, 0, 0, this);
    }

    public void paintUnbuffered(Graphics graphics) {
        if (this.useAvg) {
            if (this.cur <= this.avg) {
                graphics.setColor(this.color1);
                graphics.fillRect(0, this.yCur, this.width, this.height - this.yCur);
            } else {
                graphics.setColor(this.color2);
                graphics.fillRect(0, this.yCur, this.width, this.height - this.yCur);
                graphics.setColor(this.color1);
                graphics.fillRect(0, this.yAvg, this.width, this.height - this.yAvg);
            }
            if (this.avg < this.max) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.yAvg, this.width, this.yAvg);
            }
        } else {
            graphics.setColor(this.color1);
            graphics.fillRect(0, this.yCur, this.width, this.height - this.yCur);
        }
    }

    public void setAvg(int n) {
        this.avg = n;
        this.yCompute();
        this.repaint();
    }

    public void setCurrent(int n) {
        this.cur = n;
        this.yCompute();
        this.repaint();
    }

    public void setMax(int n) {
        this.max = n;
        this.yCompute();
        this.repaint();
    }

    public void setMin(int n) {
        this.min = n;
        this.yCompute();
        this.repaint();
    }

    private final void yCompute() {
        float f;
        if (this.useAvg) {
            f = (float)this.avg / ((float)this.max - (float)this.min) * (float)this.height;
            this.yAvg = this.yTransform((int)f);
        }
        f = (float)this.cur / ((float)this.max - (float)this.min) * (float)this.height;
        this.yCur = this.yTransform((int)f);
    }

    private final int yTransform(int n) {
        return this.height - n;
    }

    public FillLevelCanvas() {
        this.initialize();
    }
}

