/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import org.apache.avalon.framework.logger.Logger;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPProvider;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import sun.security.jgss.spi.GSSNameSpi;

public final class GSSUPNameSpi
implements GSSNameSpi {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS.GSSUP");
    private static Oid mechOid;
    private Provider provider;
    private Oid nameTypeOid;
    private InitialContextToken subject = null;

    public static final byte[] encode(String string, String string2, byte[] byArray) {
        InitialContextToken initialContextToken = null;
        try {
            initialContextToken = new InitialContextToken(string.getBytes("UTF-8"), string2.getBytes("UTF-8"), byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Error creating InitialContextToken: " + unsupportedEncodingException);
            return new byte[0];
        }
        byte[] byArray2 = null;
        Any any = GSSUPProvider.orb.create_any();
        InitialContextTokenHelper.insert(any, initialContextToken);
        try {
            byArray2 = GSSUPProvider.codec.encode_value(any);
        }
        catch (Exception exception) {
            logger.error("Error encoding for GSSNameSpi: " + exception);
            return new byte[0];
        }
        byte[] byArray3 = null;
        try {
            byArray3 = mechOid.getDER();
        }
        catch (GSSException gSSException) {
            logger.error("Error retrieving mechOid DER: " + gSSException);
            return new byte[0];
        }
        int n = byArray2.length + byArray3.length;
        byte[] byArray4 = null;
        byArray4 = n >> 7 == 0 ? new byte[]{96, (byte)n} : (n >> 14 == 0 ? new byte[]{96, (byte)(n >> 7 | 0x80), (byte)(n & 0x7F)} : (n >> 21 == 0 ? new byte[]{96, (byte)(n >> 14 | 0x80), (byte)(n >> 7 & 0x7F | 0x80), (byte)(n & 0x7F)} : (n >> 28 == 0 ? new byte[]{96, (byte)(n >> 21 | 0x80), (byte)(n >> 14 & 0x7F | 0x80), (byte)(n >> 7 & 0x7F | 0x80), (byte)(n & 0x7F)} : new byte[]{96, (byte)(n >> 28 | 0x80), (byte)(n >> 21 & 0x7F | 0x80), (byte)(n >> 14 & 0x7F | 0x80), (byte)(n >> 7 & 0x7F | 0x80), (byte)(n & 0x7F)})));
        byte[] byArray5 = new byte[n + byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        System.arraycopy(byArray2, 0, byArray5, byArray4.length + byArray3.length, byArray2.length);
        return byArray5;
    }

    public static final byte[] encode(String string, char[] cArray, String string2) {
        return GSSUPNameSpi.encode(string, new String(cArray), string2.getBytes());
    }

    public static final InitialContextToken decode(byte[] byArray) {
        if (byArray[0] != 96) {
            logger.error("GSSToken doesn't start with expected value '0x60'");
            return null;
        }
        int n = 1;
        while (n < byArray.length && (byArray[n] & 0x80) == 1) {
            ++n;
        }
        if (n == byArray.length) {
            logger.error("GSSToken doesn't contain valid length");
            return null;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = mechOid.getDER();
        }
        catch (GSSException gSSException) {
            logger.error("Error retrieving mechOid DER: " + gSSException);
            return null;
        }
        if (++n + byArray2.length >= byArray.length) {
            logger.error("GSSToken doesn't contain OID");
            return null;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray2[n2] != byArray[n + n2]) {
                logger.error("GSSToken doesn't contain GSSUPMechOID");
                return null;
            }
            ++n2;
        }
        byte[] byArray3 = new byte[byArray.length - (n += byArray2.length)];
        System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
        try {
            Any any = GSSUPProvider.codec.decode_value(byArray3, InitialContextTokenHelper.type());
            return InitialContextTokenHelper.extract(any);
        }
        catch (Exception exception) {
            logger.error("Error decoding for GSSNameSpi: " + exception);
            return null;
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final boolean equals(GSSNameSpi gSSNameSpi) throws GSSException {
        return this.subject.equals(((GSSUPNameSpi)gSSNameSpi).subject);
    }

    public final byte[] export() throws GSSException {
        Any any = GSSUPProvider.orb.create_any();
        InitialContextTokenHelper.insert(any, this.subject);
        byte[] byArray = new byte[]{};
        try {
            byArray = GSSUPProvider.codec.encode_value(any);
        }
        catch (Exception exception) {
            logger.error("Error encoding for GSSNameSpi: " + exception);
        }
        return byArray;
    }

    public final Oid getMechanism() {
        return mechOid;
    }

    public final String toString() {
        Any any = GSSUPProvider.orb.create_any();
        InitialContextTokenHelper.insert(any, this.subject);
        byte[] byArray = new byte[]{};
        try {
            byArray = GSSUPProvider.codec.encode_value(any);
        }
        catch (Exception exception) {
            logger.error("Error encoding for GSSNameSpi: " + exception);
        }
        return new String(byArray);
    }

    public final Oid getStringNameType() {
        return this.nameTypeOid;
    }

    public final boolean isAnonymousName() {
        System.out.println("GSSUPNameSpi.isAnonymousName");
        return false;
    }

    public GSSUPNameSpi(Provider provider, Oid oid, byte[] byArray, Oid oid2) {
        this.provider = provider;
        this.nameTypeOid = oid2;
        if (byArray.length > 0) {
            try {
                Any any = GSSUPProvider.codec.decode_value(byArray, InitialContextTokenHelper.type());
                this.subject = InitialContextTokenHelper.extract(any);
            }
            catch (Exception exception) {
                logger.error("Error creating GSSNameSpi: " + exception);
                this.subject = new InitialContextToken(new byte[0], new byte[0], new byte[0]);
            }
        } else {
            this.subject = new InitialContextToken(new byte[0], new byte[0], new byte[0]);
        }
    }

    static {
        try {
            mechOid = new Oid("2.23.130.1.1.1");
        }
        catch (GSSException gSSException) {
            System.out.println("GSSUPMechanism: " + gSSException);
        }
    }
}

