/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.omg.CSI.IdentityToken;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class JsseContext
implements ISASContext {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    private X509Certificate client_cert = null;

    public boolean validate(ServerRequestInfo serverRequestInfo, byte[] byArray) {
        this.client_cert = this.getClientCert(serverRequestInfo);
        return this.client_cert != null;
    }

    public String getPrincipalName() {
        if (this.client_cert == null) {
            return null;
        }
        return this.client_cert.getSubjectDN().getName();
    }

    private final X509Certificate getClientCert(ServerRequestInfo serverRequestInfo) {
        ServerRequest serverRequest = ((ServerRequestInfoImpl)serverRequestInfo).request;
        GIOPConnection gIOPConnection = serverRequest.getConnection();
        if (gIOPConnection == null) {
            logger.warn("target has no connection!");
            return null;
        }
        if (!gIOPConnection.isSSL()) {
            return null;
        }
        ServerIIOPConnection serverIIOPConnection = (ServerIIOPConnection)gIOPConnection.getTransport();
        SSLSocket sSLSocket = (SSLSocket)serverIIOPConnection.getSocket();
        try {
            return (X509Certificate)sSLSocket.getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            Debug.output(2, sSLPeerUnverifiedException);
            return null;
        }
    }

    public byte[] createClientContext(ClientRequestInfo clientRequestInfo, CompoundSecMechList compoundSecMechList) {
        return null;
    }

    public String getClientPrincipal() {
        return null;
    }

    public boolean validateContext(ServerRequestInfo serverRequestInfo, byte[] byArray) {
        return false;
    }

    public String getValidatedPrincipal() {
        return null;
    }

    public void initClient() {
    }

    public void initTarget() {
    }

    public String getMechOID() {
        return "";
    }

    public IdentityToken createIdentityToken(ClientRequestInfo clientRequestInfo, CompoundSecMechList compoundSecMechList) {
        return null;
    }
}

