/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.security.sas.SASInitializer;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SASTargetInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS.TSS");
    private static final String name = "SASTargetInterceptor";
    protected static boolean useSsl = false;
    protected ORB orb = null;
    protected Codec codec = null;
    protected int sasReplySlotID = -1;
    protected int clientUserNameSlotID = -1;
    protected int sasContextsCubby = -1;
    protected ISASContext sasContext = null;

    public String name() {
        return name;
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        IDLEntity iDLEntity;
        Object object;
        logger.debug("receive_request_service_contexts for " + serverRequestInfo.operation());
        if (this.sasContext == null) {
            return;
        }
        GIOPConnection gIOPConnection = ((ServerRequestInfoImpl)serverRequestInfo).request.getConnection();
        if (useSsl && !gIOPConnection.isSSL()) {
            logger.error("SSL required for operation " + serverRequestInfo.operation());
            throw new NO_PERMISSION("SSL Required!", 1245904899, CompletionStatus.COMPLETED_NO);
        }
        SASContextBody sASContextBody = null;
        long l = 0L;
        byte[] byArray = null;
        try {
            object = serverRequestInfo.get_request_service_context(15);
            iDLEntity = this.codec.decode_value(((ServiceContext)object).context_data, SASContextBodyHelper.type());
            sASContextBody = SASContextBodyHelper.extract((Any)iDLEntity);
        }
        catch (BAD_PARAM bAD_PARAM) {
        }
        catch (Exception exception) {
            logger.warn("Could not parse service context: " + exception);
            throw new NO_PERMISSION("Could not parse service context: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
        }
        if (sASContextBody == null) {
            return;
        }
        if (sASContextBody.discriminator() == 5) {
            object = null;
            try {
                object = sASContextBody.in_context_msg();
                l = ((MessageInContext)object).client_context_id;
                byArray = this.getSASContext(gIOPConnection, ((MessageInContext)object).client_context_id);
            }
            catch (Exception exception) {
                logger.error("Could not parse service MessageInContext " + serverRequestInfo.operation() + ": " + exception);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (byArray == null) {
                logger.error("Could not parse service MessageInContext " + serverRequestInfo.operation() + ": " + ((MessageInContext)object).client_context_id);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        object = null;
        if (sASContextBody.discriminator() == 0) {
            iDLEntity = null;
            try {
                iDLEntity = sASContextBody.establish_msg();
                l = ((EstablishContext)iDLEntity).client_context_id;
                byArray = ((EstablishContext)iDLEntity).client_authentication_token;
                if (!this.sasContext.validateContext(serverRequestInfo, byArray)) {
                    throw new NO_PERMISSION("SAS Error validating context", 1245904899, CompletionStatus.COMPLETED_NO);
                }
                object = this.sasContext.getValidatedPrincipal();
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                logger.error("Err " + serverRequestInfo.operation() + ": " + nO_PERMISSION);
                throw nO_PERMISSION;
            }
            catch (Exception exception) {
                logger.error("Could not parse service EstablishContext " + serverRequestInfo.operation() + ": " + exception);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (byArray == null) {
                logger.error("Could not parse service EstablishContext " + serverRequestInfo.operation() + ": " + ((EstablishContext)iDLEntity).client_context_id);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        try {
            iDLEntity = this.orb.create_any();
            if (object == null) {
                object = this.getSASContextPrincipalName(gIOPConnection, l);
            }
            ((Any)iDLEntity).insert_string((String)object);
            serverRequestInfo.set_slot(SASInitializer.sasPrincipalNamePIC, (Any)iDLEntity);
        }
        catch (Exception exception) {
            logger.error("Error inserting service context into slots for " + serverRequestInfo.operation() + ": " + exception);
            try {
                serverRequestInfo.set_slot(this.sasReplySlotID, this.makeContextError(l, 1, 1, byArray));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new NO_PERMISSION("SAS Error insert service context into slots: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
        }
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Object object;
        IDLEntity iDLEntity;
        Object object2;
        Object object3;
        Object object4;
        logger.debug("receive_request for " + serverRequestInfo.operation());
        if (this.sasContext == null) {
            return;
        }
        GIOPConnection gIOPConnection = ((ServerRequestInfoImpl)serverRequestInfo).request.getConnection();
        SASPolicyValues sASPolicyValues = null;
        try {
            object4 = (ObjectImpl)((ServerRequestInfoImpl)serverRequestInfo).target();
            object3 = (Delegate)((ObjectImpl)object4)._get_delegate();
            object2 = (SASPolicy)((Delegate)object3).getPOA().getPolicy(100);
            if (object2 != null) {
                sASPolicyValues = object2.value();
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No SAS Policy for " + serverRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("Error fetching SAS policy for " + serverRequestInfo.operation() + ": " + exception);
            throw new NO_PERMISSION("Error fetching SAS policy: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
        }
        if (sASPolicyValues == null) {
            return;
        }
        if (sASPolicyValues.targetRequires == 0 && sASPolicyValues.targetSupports == 0) {
            return;
        }
        object4 = null;
        try {
            object3 = (ObjectImpl)((ServerRequestInfoImpl)serverRequestInfo).target();
            object2 = (Delegate)((ObjectImpl)object3)._get_delegate();
            ATLASPolicy aTLASPolicy = (ATLASPolicy)((Delegate)object2).getPOA().getPolicy(101);
            if (aTLASPolicy != null) {
                object4 = aTLASPolicy.value();
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No ATLAS Policy for " + serverRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("Error fetching ATLAS policy for " + serverRequestInfo.operation() + ": " + exception);
            throw new NO_PERMISSION("Error fetching ATLAS policy: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
        }
        object3 = null;
        long l = 0L;
        byte[] byArray = null;
        try {
            iDLEntity = serverRequestInfo.get_request_service_context(15);
            object = this.codec.decode_value(iDLEntity.context_data, SASContextBodyHelper.type());
            object3 = SASContextBodyHelper.extract((Any)object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.warn("Could not parse service context for operation " + serverRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("Could not parse service context for operation " + serverRequestInfo.operation() + ": " + exception);
        }
        if (object3 == null && (sASPolicyValues.targetRequires & 0x40) != 0 && !serverRequestInfo.operation().equals("_non_existent") && !serverRequestInfo.operation().equals("_is_a")) {
            logger.error("Did not parse service context for operation " + serverRequestInfo.operation());
            throw new NO_PERMISSION("No SAS service context found", 1245904899, CompletionStatus.COMPLETED_NO);
        }
        if (object3 == null) {
            logger.debug("No context found, but not required");
            return;
        }
        if (((SASContextBody)object3).discriminator() == 5) {
            iDLEntity = null;
            try {
                iDLEntity = ((SASContextBody)object3).in_context_msg();
                l = ((MessageInContext)iDLEntity).client_context_id;
                byArray = this.getSASContext(gIOPConnection, ((MessageInContext)iDLEntity).client_context_id);
            }
            catch (Exception exception) {
                logger.error("Could not parse service MessageInContext " + serverRequestInfo.operation() + ": " + exception);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (byArray == null) {
                logger.error("Could not parse service MessageInContext " + serverRequestInfo.operation() + ": " + ((MessageInContext)iDLEntity).client_context_id);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        if (((SASContextBody)object3).discriminator() == 0) {
            iDLEntity = null;
            object = null;
            try {
                iDLEntity = ((SASContextBody)object3).establish_msg();
                l = ((EstablishContext)iDLEntity).client_context_id;
                byArray = ((EstablishContext)iDLEntity).client_authentication_token;
                object = this.sasContext.getValidatedPrincipal();
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                logger.error("Err " + serverRequestInfo.operation() + ": " + nO_PERMISSION);
                throw nO_PERMISSION;
            }
            catch (Exception exception) {
                logger.error("Could not parse service EstablishContext " + serverRequestInfo.operation() + ": " + exception);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (byArray == null) {
                logger.error("Could not parse service EstablishContext " + serverRequestInfo.operation() + ": " + ((EstablishContext)iDLEntity).client_context_id);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (sASPolicyValues.stateful) {
                this.cacheSASContext(gIOPConnection, ((EstablishContext)iDLEntity).client_context_id, byArray, (String)object);
            }
        }
        try {
            serverRequestInfo.set_slot(this.sasReplySlotID, this.makeCompleteEstablishContext(l, sASPolicyValues));
        }
        catch (Exception exception) {
            logger.error("Error inserting service context into slots for " + serverRequestInfo.operation() + ": " + exception);
            try {
                serverRequestInfo.set_slot(this.sasReplySlotID, this.makeContextError(l, 1, 1, byArray));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new NO_PERMISSION("SAS Error insert service context into slots: " + exception, 1245904899, CompletionStatus.COMPLETED_NO);
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        logger.debug("send_reply for " + serverRequestInfo.operation());
        Any any = null;
        try {
            any = serverRequestInfo.get_slot(this.sasReplySlotID);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No SAS reply found " + serverRequestInfo.operation() + ": ");
        }
        catch (Exception exception) {
            logger.warn("No SAS reply found " + serverRequestInfo.operation() + ": ");
        }
        if (any == null) {
            return;
        }
        try {
            serverRequestInfo.add_reply_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
        }
        catch (Exception exception) {
            logger.error("Error setting reply service context " + serverRequestInfo.operation() + ": " + exception);
            throw new NO_PERMISSION("SAS Error setting reply service contex: " + exception, 1245904899, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        logger.debug("send_exception for " + serverRequestInfo.operation());
        Any any = null;
        try {
            any = serverRequestInfo.get_slot(this.sasReplySlotID);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No SAS reply found " + serverRequestInfo.operation() + ": ");
        }
        catch (Exception exception) {
            logger.warn("No SAS reply found " + serverRequestInfo.operation() + ": ");
        }
        if (any == null) {
            return;
        }
        try {
            serverRequestInfo.add_reply_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
        }
        catch (Exception exception) {
            logger.error("Error setting reply service context:" + exception);
            throw new NO_PERMISSION("SAS Error setting reply service context: " + exception, 1245904899, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        logger.debug("send_other for " + serverRequestInfo.operation());
    }

    protected Any makeCompleteEstablishContext(long l, SASPolicyValues sASPolicyValues) {
        CompleteEstablishContext completeEstablishContext = new CompleteEstablishContext();
        completeEstablishContext.client_context_id = l;
        completeEstablishContext.context_stateful = sASPolicyValues.stateful;
        completeEstablishContext.final_context_token = new byte[0];
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.complete_msg(completeEstablishContext);
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        return any;
    }

    protected Any makeContextError(long l, int n, int n2, byte[] byArray) {
        ContextError contextError = new ContextError();
        contextError.client_context_id = l;
        contextError.error_token = byArray;
        contextError.major_status = n;
        contextError.minor_status = n2;
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.error_msg(contextError);
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        return any;
    }

    public void cacheSASContext(GIOPConnection gIOPConnection, long l, byte[] byArray, String string) {
        GIOPConnection gIOPConnection2 = gIOPConnection;
        synchronized (gIOPConnection2) {
            Hashtable<Long, CachedContext> hashtable = (Hashtable<Long, CachedContext>)gIOPConnection.get_cubby(this.sasContextsCubby);
            if (hashtable == null) {
                hashtable = new Hashtable<Long, CachedContext>();
                gIOPConnection.set_cubby(this.sasContextsCubby, hashtable);
            }
            hashtable.put(new Long(l), new CachedContext(byArray, string));
        }
    }

    public void purgeSASContext(GIOPConnection gIOPConnection, long l) {
        GIOPConnection gIOPConnection2 = gIOPConnection;
        synchronized (gIOPConnection2) {
            Hashtable hashtable = (Hashtable)gIOPConnection.get_cubby(this.sasContextsCubby);
            if (hashtable == null) {
                hashtable = new Hashtable();
                gIOPConnection.set_cubby(this.sasContextsCubby, hashtable);
            }
            hashtable.remove(new Long(l));
        }
    }

    public byte[] getSASContext(GIOPConnection gIOPConnection, long l) {
        Long l2 = new Long(l);
        GIOPConnection gIOPConnection2 = gIOPConnection;
        synchronized (gIOPConnection2) {
            Hashtable hashtable = (Hashtable)gIOPConnection.get_cubby(this.sasContextsCubby);
            if (hashtable == null) {
                hashtable = new Hashtable();
                gIOPConnection.set_cubby(this.sasContextsCubby, hashtable);
            }
            if (!hashtable.containsKey(l2)) {
                return null;
            }
            return ((CachedContext)hashtable.get((Object)l2)).client_authentication_token;
        }
    }

    public String getSASContextPrincipalName(GIOPConnection gIOPConnection, long l) {
        Long l2 = new Long(l);
        GIOPConnection gIOPConnection2 = gIOPConnection;
        synchronized (gIOPConnection2) {
            Hashtable hashtable = (Hashtable)gIOPConnection.get_cubby(this.sasContextsCubby);
            if (hashtable == null) {
                hashtable = new Hashtable();
                gIOPConnection.set_cubby(this.sasContextsCubby, hashtable);
            }
            if (!hashtable.containsKey(l2)) {
                return null;
            }
            return ((CachedContext)hashtable.get((Object)l2)).principalName;
        }
    }

    public SASTargetInterceptor(ORBInitInfo oRBInitInfo) throws UnknownEncoding {
        this.sasReplySlotID = oRBInitInfo.allocate_slot_id();
        this.sasContextsCubby = GIOPConnection.allocate_cubby_id();
        Encoding encoding = new Encoding(0, 1, 0);
        this.codec = oRBInitInfo.codec_factory().create_codec(encoding);
        this.orb = ((ORBInitInfoImpl)oRBInitInfo).getORB();
        useSsl = Boolean.valueOf(Environment.getProperty("jacorb.security.sas.tss.requires_sas", "false"));
        String string = Environment.getProperty("jacorb.security.sas.contextClass");
        if (string != null) {
            try {
                Class clazz = Environment.classForName(string);
                this.sasContext = (ISASContext)clazz.newInstance();
            }
            catch (Exception exception) {
                logger.error("Could not instantiate class " + string + ": " + exception);
            }
        }
        if (this.sasContext == null) {
            logger.error("Could not load SAS context class: " + string);
        } else {
            this.sasContext.initTarget();
        }
    }

    class CachedContext {
        public byte[] client_authentication_token;
        public String principalName;

        CachedContext(byte[] byArray, String string) {
            this.client_authentication_token = byArray;
            this.principalName = string;
        }
    }
}

