/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.ReceivedCredentialsImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.Debug;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.ReceivedCredentials;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = null;
    private CurrentImpl current = null;
    private SecAttributeManager attrib_mgr = null;
    private AttributeType type = null;
    private Logger logger;

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        ServerRequest serverRequest = ((ServerRequestInfoImpl)serverRequestInfo).request;
        GIOPConnection gIOPConnection = serverRequest.getConnection();
        if (gIOPConnection == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("target has no connection!");
            }
            return;
        }
        if (!gIOPConnection.isSSL()) {
            return;
        }
        ServerIIOPConnection serverIIOPConnection = (ServerIIOPConnection)gIOPConnection.getTransport();
        SSLSocket sSLSocket = (SSLSocket)serverIIOPConnection.getSocket();
        KeyAndCert keyAndCert = null;
        try {
            keyAndCert = new KeyAndCert(null, sSLSocket.getSession().getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + sSLPeerUnverifiedException.getMessage() + " in ServerInvocationInterceptor");
            }
            return;
        }
        if (keyAndCert.chain == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client sent no certificate chain!");
            }
            return;
        }
        SecAttribute[] secAttributeArray = new SecAttribute[]{this.attrib_mgr.createAttribute(keyAndCert, this.type)};
        this.current.set_received_credentials(new ReceivedCredentialsImpl(secAttributeArray));
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    private final void removeAttribute() {
        ReceivedCredentials receivedCredentials = this.current.received_credentials();
        if (receivedCredentials == null) {
            return;
        }
        SecAttribute[] secAttributeArray = receivedCredentials.get_attributes(new AttributeType[]{this.type});
        if (secAttributeArray.length != 0) {
            this.attrib_mgr.removeAttribute(secAttributeArray[0]);
        }
    }

    public ServerInvocationInterceptor(Current current) {
        this(current, DEFAULT_NAME);
    }

    public ServerInvocationInterceptor(Current current, String string) {
        this.current = (CurrentImpl)current;
        this.name = string;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.logger = Debug.getNamedLogger("jacorb.security.jsse");
    }
}

