/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.constraint.ValueType;

public class AndNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    public void print(PrintStream printStream) {
        printStream.println("AndNode: type = " + this.getType());
        printStream.println("Left node:");
        this.m_left.print(printStream);
        printStream.println("Right node:");
        this.m_right.print(printStream);
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = null;
        int n = this.getType().getId();
        Value value2 = this.m_left.evaluate(propertySource);
        Boolean bl = (Boolean)value2.getValue();
        if (bl.booleanValue()) {
            Value value3 = this.m_right.evaluate(propertySource);
            Boolean bl2 = (Boolean)value3.getValue();
            value = ValueFactory.createBoolean(bl2);
        } else {
            value = ValueFactory.createBoolean(false);
        }
        return value;
    }

    private AndNode() {
    }

    public AndNode(ExprNode exprNode, ExprNode exprNode2) {
        this.m_left = exprNode;
        this.m_right = exprNode2;
        this.setType(new ValueType(0));
    }
}

