/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class DoubleValue
implements Value {
    private Double m_value;

    public void setValue(Object object) {
        this.m_value = (Double)object;
    }

    public int getTypeId() {
        return 6;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)value.getValue();
        bl = this.m_value < d;
        return bl;
    }

    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    public Value plus(Value value) {
        DoubleValue doubleValue = null;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)value.getValue();
        doubleValue = new DoubleValue(this.m_value + d);
        return doubleValue;
    }

    public Value minus(Value value) {
        DoubleValue doubleValue = null;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)value.getValue();
        doubleValue = new DoubleValue(this.m_value - d);
        return doubleValue;
    }

    public Value multiply(Value value) {
        DoubleValue doubleValue = null;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)value.getValue();
        doubleValue = new DoubleValue(this.m_value * d);
        return doubleValue;
    }

    public Value divide(Value value) {
        DoubleValue doubleValue = null;
        if (value.getTypeId() != 6) {
            throw new IllegalArgumentException();
        }
        Double d = (Double)value.getValue();
        doubleValue = new DoubleValue(this.m_value / d);
        return doubleValue;
    }

    public Value negate() {
        DoubleValue doubleValue = null;
        doubleValue = new DoubleValue(-1.0 * this.m_value);
        return doubleValue;
    }

    public Value convert(int n) {
        DoubleValue doubleValue = null;
        switch (n) {
            case 6: {
                doubleValue = new DoubleValue(this.m_value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return doubleValue;
    }

    public String toString() {
        return this.m_value.toString();
    }

    public DoubleValue() {
        this(0.0);
    }

    public DoubleValue(double d) {
        this.m_value = new Double(d);
    }

    public DoubleValue(Object object) {
        this.m_value = (Double)object;
    }
}

