/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.OfferProperty;
import org.jacorb.trading.db.simple.offers.ProxyPolicy;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;

public class ProxyOffer
implements Serializable {
    static final long serialVersionUID = -2760477527985159980L;
    private String m_id;
    private String m_target;
    private Vector m_props;
    private boolean m_ifMatchAll;
    private String m_recipe;
    private Vector m_policies;
    private transient ProxyInfo m_description;

    public ProxyInfo describe() {
        ProxyInfo proxyInfo = null;
        if (this.m_description == null) {
            Serializable serializable;
            proxyInfo = new ProxyInfo();
            Object object = TradingService.getORB().string_to_object(this.m_target);
            proxyInfo.target = LookupHelper.narrow(object);
            proxyInfo.properties = new Property[this.m_props.size()];
            int n = 0;
            Enumeration enumeration = this.m_props.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (OfferProperty)enumeration.nextElement();
                proxyInfo.properties[n] = ((OfferProperty)serializable).describe();
                ++n;
            }
            proxyInfo.if_match_all = this.m_ifMatchAll;
            proxyInfo.recipe = this.m_recipe;
            proxyInfo.policies_to_pass_on = new Policy[this.m_policies.size()];
            n = 0;
            enumeration = this.m_policies.elements();
            while (enumeration.hasMoreElements()) {
                serializable = (ProxyPolicy)enumeration.nextElement();
                proxyInfo.policies_to_pass_on[n] = ((ProxyPolicy)serializable).describe();
                ++n;
            }
            this.m_description = proxyInfo;
        } else {
            proxyInfo = this.m_description;
        }
        return proxyInfo;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(java.lang.Object object) {
        ProxyOffer proxyOffer = (ProxyOffer)object;
        return this.m_id.equals(proxyOffer.m_id);
    }

    protected void setProperties(Property[] propertyArray) {
        this.m_props = new Vector();
        int n = 0;
        while (n < propertyArray.length) {
            OfferProperty offerProperty = new OfferProperty(propertyArray[n]);
            this.m_props.addElement(offerProperty);
            ++n;
        }
    }

    protected void setPolicies(Policy[] policyArray) {
        this.m_policies = new Vector();
        int n = 0;
        while (n < policyArray.length) {
            ProxyPolicy proxyPolicy = new ProxyPolicy(policyArray[n]);
            this.m_policies.addElement(proxyPolicy);
            ++n;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_description = null;
    }

    private ProxyOffer() {
    }

    public ProxyOffer(String string, Lookup lookup, Property[] propertyArray, boolean bl, String string2, Policy[] policyArray) {
        this.m_id = string;
        this.m_target = TradingService.getORB().object_to_string(lookup);
        this.setProperties(propertyArray);
        this.m_ifMatchAll = bl;
        this.m_recipe = string2;
        this.setPolicies(policyArray);
        this.m_description = null;
    }
}

