/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.impl.OfferListener;
import org.jacorb.trading.impl.ProxySourceAdapter;
import org.jacorb.trading.impl.Recipe;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.util.MessageQueue;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;

public class OfferEvaluator
implements Runnable,
OfferListener {
    private static final int MAX_DYNAMIC_THREADS = 10;
    private static final int MAX_PROXY_THREADS = 10;
    private String m_type;
    private Constraint m_constraint;
    private String m_preference;
    private Policy[] m_policies;
    private SpecifiedProps m_desiredProps;
    private Vector m_sources;
    private int m_matchCard;
    private int m_matchCount;
    private Vector m_results;
    private int m_numProcessed;
    private int m_threadPriority;
    private int m_numDynamicThreads;
    private int m_numProxyThreads;
    private MessageQueue m_proxyQueue;
    private MessageQueue m_dynamicQueue;

    public synchronized Vector getResults() {
        while (!this.getDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_results;
    }

    public synchronized boolean getDone() {
        boolean bl = this.m_matchCard == this.m_matchCount || this.m_numProcessed == this.m_sources.size();
        return bl;
    }

    public synchronized boolean offerNotify(SourceAdapter sourceAdapter) {
        this.addSource(sourceAdapter);
        if (this.getDone()) {
            this.notifyAll();
        }
        return !this.getDone();
    }

    public synchronized void sourceNotify(SourceAdapter sourceAdapter) {
        ++this.m_numProcessed;
        if (this.getDone()) {
            this.notifyAll();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        Enumeration enumeration = this.m_sources.elements();
        while (enumeration.hasMoreElements() && !this.getDone()) {
            object = (SourceAdapter)enumeration.nextElement();
            if (object instanceof ProxySourceAdapter) {
                this.scheduleProxy((SourceAdapter)object);
                continue;
            }
            if (PropUtil.hasDynamicProperties(((SourceAdapter)object).getProperties())) {
                this.scheduleDynamic((SourceAdapter)object);
                continue;
            }
            if (this.m_constraint.evaluate((PropertySource)object)) {
                this.offerNotify((SourceAdapter)object);
            }
            this.sourceNotify((SourceAdapter)object);
        }
        object = this;
        synchronized (object) {
            while (true) {
                while (true) {
                    if (this.getDone()) {
                        this.m_dynamicQueue.deactivate();
                        this.m_proxyQueue.deactivate();
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                break;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    protected synchronized void scheduleDynamic(SourceAdapter sourceAdapter) {
        if (this.m_numDynamicThreads < 10) {
            DynEval dynEval = new DynEval(this.m_dynamicQueue, this.m_constraint, this.m_desiredProps, this);
            ++this.m_numDynamicThreads;
            dynEval.setPriority(this.m_threadPriority);
            dynEval.start();
        }
        this.m_dynamicQueue.enqueue(sourceAdapter);
    }

    protected synchronized void scheduleProxy(SourceAdapter sourceAdapter) {
        if (this.m_numProxyThreads < 10) {
            ProxyEval proxyEval = new ProxyEval(this.m_proxyQueue, this.m_type, this.m_constraint, this.m_preference, this.m_policies, this.m_desiredProps, this);
            ++this.m_numProxyThreads;
            proxyEval.setPriority(this.m_threadPriority);
            proxyEval.start();
        }
        this.m_proxyQueue.enqueue(sourceAdapter);
    }

    protected synchronized void addSource(SourceAdapter sourceAdapter) {
        if (this.m_matchCount < this.m_matchCard) {
            this.m_results.addElement(sourceAdapter);
            ++this.m_matchCount;
        }
    }

    public OfferEvaluator(String string, Constraint constraint, String string2, Policy[] policyArray, SpecifiedProps specifiedProps, Vector vector, int n) {
        this.m_type = string;
        this.m_constraint = constraint;
        this.m_preference = string2;
        this.m_policies = policyArray;
        this.m_desiredProps = specifiedProps;
        this.m_sources = vector;
        this.m_matchCard = n;
        this.m_matchCount = 0;
        this.m_results = new Vector();
        this.m_numProcessed = 0;
        this.m_threadPriority = Thread.currentThread().getPriority();
        if (this.m_threadPriority < 10) {
            ++this.m_threadPriority;
        }
        this.m_numDynamicThreads = 0;
        this.m_numProxyThreads = 0;
        this.m_proxyQueue = new MessageQueue();
        this.m_dynamicQueue = new MessageQueue();
        new Thread(this).start();
    }

    protected static class DynEval
    extends Thread {
        private MessageQueue m_queue;
        private Constraint m_constraint;
        private SpecifiedProps m_desiredProps;
        private OfferListener m_listener;

        public void run() {
            SourceAdapter sourceAdapter;
            while ((sourceAdapter = (SourceAdapter)this.m_queue.dequeue()) != null) {
                if (this.m_constraint.evaluate(sourceAdapter)) {
                    Property[] propertyArray = sourceAdapter.getProperties();
                    if (this.m_desiredProps.discriminator() == HowManyProps.all) {
                        int n = 0;
                        while (n < propertyArray.length) {
                            sourceAdapter.getPropertyValue(propertyArray[n].name);
                            ++n;
                        }
                    } else if (this.m_desiredProps.discriminator() == HowManyProps.some) {
                        String[] stringArray = this.m_desiredProps.prop_names();
                        int n = 0;
                        while (n < stringArray.length) {
                            sourceAdapter.getPropertyValue(stringArray[n]);
                            ++n;
                        }
                    }
                    this.m_listener.offerNotify(sourceAdapter);
                }
                this.m_listener.sourceNotify(sourceAdapter);
            }
        }

        public DynEval(MessageQueue messageQueue, Constraint constraint, SpecifiedProps specifiedProps, OfferListener offerListener) {
            this.m_queue = messageQueue;
            this.m_constraint = constraint;
            this.m_desiredProps = specifiedProps;
            this.m_listener = offerListener;
        }
    }

    protected static class ProxyEval
    extends Thread {
        private MessageQueue m_queue;
        private String m_type;
        private Constraint m_constraint;
        private String m_preference;
        private Policy[] m_policies;
        private SpecifiedProps m_desiredProps;
        private OfferListener m_listener;

        public void run() {
            ProxySourceAdapter proxySourceAdapter;
            while ((proxySourceAdapter = (ProxySourceAdapter)this.m_queue.dequeue()) != null) {
                String string;
                String string2;
                ProxyInfo proxyInfo = proxySourceAdapter.getInfo();
                boolean bl = false;
                bl = proxyInfo.if_match_all ? true : this.m_constraint.evaluate(proxySourceAdapter);
                if (bl && (string2 = Recipe.rewrite(proxyInfo.recipe, proxySourceAdapter, string = this.m_constraint.getConstraint())) != null) {
                    Policy[] policyArray = new Policy[this.m_policies.length + proxyInfo.policies_to_pass_on.length];
                    int n = 0;
                    while (n < this.m_policies.length) {
                        policyArray[n] = this.m_policies[n];
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < proxyInfo.policies_to_pass_on.length) {
                        policyArray[n++] = proxyInfo.policies_to_pass_on[n2];
                        ++n2;
                    }
                    try {
                        OfferSeqHolder offerSeqHolder = new OfferSeqHolder();
                        OfferIteratorHolder offerIteratorHolder = new OfferIteratorHolder();
                        PolicyNameSeqHolder policyNameSeqHolder = new PolicyNameSeqHolder();
                        proxyInfo.target.query(this.m_type, string2, this.m_preference, policyArray, this.m_desiredProps, 0, offerSeqHolder, offerIteratorHolder, policyNameSeqHolder);
                        if (offerIteratorHolder.value != null) {
                            boolean bl2;
                            OfferSeqHolder offerSeqHolder2 = new OfferSeqHolder();
                            block6: do {
                                bl2 = offerIteratorHolder.value.next_n(20, offerSeqHolder2);
                                int n3 = 0;
                                while (n3 < offerSeqHolder2.value.length) {
                                    Offer offer = offerSeqHolder2.value[n3];
                                    SourceAdapter sourceAdapter = new SourceAdapter(offer.reference, offer.properties);
                                    if (!this.m_listener.offerNotify(sourceAdapter)) continue block6;
                                    ++n3;
                                }
                            } while (bl2);
                            offerIteratorHolder.value.destroy();
                        }
                    }
                    catch (UserException userException) {
                    }
                    catch (SystemException systemException) {
                        // empty catch block
                    }
                }
                this.m_listener.sourceNotify(proxySourceAdapter);
            }
        }

        public ProxyEval(MessageQueue messageQueue, String string, Constraint constraint, String string2, Policy[] policyArray, SpecifiedProps specifiedProps, OfferListener offerListener) {
            this.m_queue = messageQueue;
            this.m_type = string;
            this.m_constraint = constraint;
            this.m_preference = string2;
            this.m_policies = policyArray;
            this.m_desiredProps = specifiedProps;
            this.m_listener = offerListener;
        }
    }
}

