/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

import org.jacorb.trading.util.QueryContainer;
import org.jacorb.trading.util.Semaphore;
import org.jacorb.trading.util.TimeoutThread;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.Offer;

public class QueryPropagator {
    private static int threadc = 0;
    private int m_idle_threads = 0;
    private int m_total_threads = 0;
    private Semaphore m_idle_threads_sema = new Semaphore();
    private QueryContainer m_new_query;
    private Semaphore m_query_cons = new Semaphore(0);
    private Semaphore m_query_prod = new Semaphore();
    private int m_max_threads = 10;
    private int m_min_threads = 5;
    private int m_query_timeout = 60000;
    private TimeoutThread m_timer = null;
    private boolean m_debug = false;
    private int m_debug_verbosity = 2;

    public void putWork(QueryContainer queryContainer) {
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "Put work (waiting): query(" + queryContainer.no + ")");
        }
        this.m_query_prod.P();
        boolean bl = this.m_idle_threads < this.m_min_threads && this.m_total_threads < this.m_max_threads;
        this.m_new_query = queryContainer;
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "Put work (got P) query(" + this.m_new_query.no + ")");
        }
        this.m_query_cons.V();
        if (this.m_debug) {
            Debug.output(this.m_debug_verbosity, "left put work: query(" + this.m_new_query.no + ")");
        }
        if (bl) {
            if (this.m_debug) {
                Debug.output(this.m_debug_verbosity, "Not enough Threads: " + this.m_idle_threads);
            }
            QueryThread queryThread = new QueryThread(this.m_timer);
        }
    }

    public QueryPropagator() {
        String string = Environment.getProperty("jtrader.util.max_threads");
        if (string != null) {
            try {
                this.m_max_threads = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        if ((string = Environment.getProperty("jtrader.util.min_threads")) != null) {
            try {
                this.m_min_threads = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        if ((string = Environment.getProperty("jtrader.util.query_timeout")) != null) {
            try {
                this.m_query_timeout = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        if ((string = Environment.getProperty("jtrader.debug")) != null) {
            try {
                this.m_debug = Boolean.valueOf(string);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        if ((string = Environment.getProperty("jtrader.debug_verbosity")) != null) {
            try {
                this.m_debug_verbosity = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        this.m_timer = new TimeoutThread(this.m_query_timeout);
    }

    private class QueryThread
    extends Thread {
        private QueryContainer m_query = null;
        private int no = 0;
        private TimeoutThread m_timer;

        public void run() {
            if (QueryPropagator.this.m_debug) {
                Debug.output(QueryPropagator.this.m_debug_verbosity, "Thread started (" + this.no + ")");
            }
            while (true) {
                QueryPropagator queryPropagator = QueryPropagator.this;
                queryPropagator.m_idle_threads = queryPropagator.m_idle_threads + 1;
                this.getWork();
                this.executeQuery();
            }
        }

        private final synchronized void executeQuery() {
            try {
                this.m_timer.setTimeout(this);
                this.m_query.m_target.query(this.m_query.m_type, this.m_query.m_constr, this.m_query.m_pref, this.m_query.m_policies, this.m_query.m_desired_props, this.m_query.m_how_many, this.m_query.m_offers, this.m_query.m_offer_itr, this.m_query.m_limits_applied);
                this.m_timer.stopTimer(this);
            }
            catch (UserException userException) {
                this.m_query.m_exception = userException;
                this.m_query.m_offers.value = new Offer[0];
                this.m_query.m_limits_applied.value = new String[0];
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                this.m_query.m_offers.value = new Offer[0];
                this.m_query.m_limits_applied.value = new String[0];
            }
            this.m_query.m_mutex.V();
            this.m_query = null;
        }

        private final void getWork() {
            if (QueryPropagator.this.m_debug) {
                Debug.output(QueryPropagator.this.m_debug_verbosity, "++Thread waiting for work: (" + this.no + ")");
            }
            QueryPropagator.this.m_query_cons.P();
            this.m_query = QueryPropagator.this.m_new_query;
            QueryPropagator queryPropagator = QueryPropagator.this;
            queryPropagator.m_idle_threads = queryPropagator.m_idle_threads - 1;
            QueryPropagator.this.m_query_prod.V();
            if (QueryPropagator.this.m_debug) {
                Debug.output(QueryPropagator.this.m_debug_verbosity, "++Thread got work: (T: " + this.no + ") (Q:" + this.m_query.no + ")");
            }
        }

        public QueryThread(TimeoutThread timeoutThread) {
            int n = threadc;
            threadc = n + 1;
            this.no = n;
            QueryPropagator queryPropagator2 = QueryPropagator.this;
            queryPropagator2.m_total_threads = queryPropagator2.m_total_threads + 1;
            this.m_timer = timeoutThread;
            this.start();
        }
    }
}

