/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

import java.util.Hashtable;
import org.jacorb.trading.util.TimerListNode;
import org.jacorb.util.Debug;

public class TimeoutThread
extends Thread {
    private int timeout = 0;
    private TimerListNode last = null;
    private TimerListNode first = null;
    private Hashtable current_nodes = null;

    public void run() {
        while (true) {
            try {
                this.first = this.first.getNext();
                if (this.first.wakeup_time <= System.currentTimeMillis()) {
                    this.first.doInterrupt();
                    continue;
                }
                Thread.sleep(Math.abs(this.first.wakeup_time - System.currentTimeMillis()));
                this.first.doInterrupt();
                continue;
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                continue;
            }
            break;
        }
    }

    public void stopTimer(Thread thread) {
        Debug.output(2, "Timer.stop for interruptee " + thread.toString());
        TimerListNode timerListNode = (TimerListNode)this.current_nodes.get(thread);
        timerListNode.stopTimer();
    }

    public synchronized void setTimeout(Thread thread) {
        TimerListNode timerListNode = new TimerListNode(thread, (long)this.timeout + System.currentTimeMillis());
        this.last.setNext(timerListNode);
        this.last = timerListNode;
        this.current_nodes.put(thread, timerListNode);
    }

    public TimeoutThread(int n) {
        this.timeout = n;
        this.first = this.last = new TimerListNode();
        this.current_nodes = new Hashtable();
        this.start();
    }
}

