/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

import org.jacorb.util.Debug;

public class TimerListNode {
    private TimerListNode next = null;
    private boolean do_interrupt = true;
    private boolean interrupt_sent = false;
    public Thread interruptee = null;
    public long wakeup_time;

    public boolean hasNext() {
        return this.next != null;
    }

    public synchronized TimerListNode getNext() {
        while (this.next == null) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        return this.next;
    }

    public synchronized void setNext(TimerListNode timerListNode) {
        this.next = timerListNode;
        this.notifyAll();
    }

    public synchronized void doInterrupt() {
        if (this.do_interrupt) {
            this.interrupt_sent = true;
            this.interruptee.interrupt();
            Debug.output(2, "interrupt for interruptee " + this.interruptee.toString());
        } else {
            Debug.output(2, "not interrupting " + this.interruptee.toString());
        }
    }

    public synchronized void stopTimer() {
        Debug.output(2, "Timer.stop (node) for interruptee " + this.interruptee.toString());
        if (!this.interrupt_sent) {
            this.do_interrupt = false;
        } else {
            try {
                this.wait();
                Debug.output(2, "waiting for interrupt " + this.interruptee.toString());
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
    }

    public TimerListNode() {
    }

    public TimerListNode(Thread thread, long l) {
        this.interruptee = thread;
        this.wakeup_time = l;
    }
}

