/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;
import org.jacorb.util.LoggerFactory;
import org.omg.CORBA.BAD_QOS;

public class Environment {
    private static Properties configurationProperties;
    private static final String propertiesFile1 = ".jacorb_properties";
    private static final String propertiesFile2 = "jacorb.properties";
    private static final String jacorbPrefix = "jacorb.";
    private static final String poaPrefix = "jacorb.poa.";
    private static LoggerFactory loggerFactory;
    private static Logger logger;
    private static final String loggerFactoryClzName = "org.jacorb.util.LogKitLoggerFactory";
    private static Class identityHashMapClass;
    private static int _client_pending_reply_timeout;
    private static int _retries;
    private static long _retry_interval;
    private static int maxManagedBufSize;
    private static int compactTypecodes;
    private static boolean _locate_on_bind;
    private static boolean _use_imr;
    private static boolean _use_imr_endpoint;
    private static boolean _cache_references;
    private static String logFileName;
    private static long _max_log_size;
    private static boolean append;
    private static long _current_log_size;
    private static boolean _useIndirection;
    private static boolean _monitoring_on;
    private static int _thread_pool_max;
    private static int _thread_pool_min;
    private static int _queue_max;
    private static int _queue_min;
    private static boolean _queue_wait;
    private static boolean _use_appligator_for_applets;
    private static boolean _use_appligator_for_applications;
    public static URL URL;
    private static byte[] _impl_name;
    private static byte[] _server_id;
    private static Map untrimmedPrefixProps;
    private static Map trimmedPrefixProps;
    private static boolean _strict_check_on_tc_creation;
    private static boolean _retry_on_failure;

    public static void init() {
        try {
            Object object;
            configurationProperties = new Properties();
            String string = System.getProperty("user.home");
            String string2 = System.getProperty("file.separator");
            String string3 = System.getProperty("java.home");
            try {
                Environment.loadProperties(string3 + string2 + "lib" + string2 + propertiesFile1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Environment.loadProperties(string3 + string2 + "lib" + string2 + propertiesFile2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Environment.loadProperties(string + string2 + propertiesFile1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Environment.loadProperties(string + string2 + propertiesFile2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                object = null;
                object = ClassLoader.getSystemResource(propertiesFile1);
                if (object == null) {
                    object = ClassLoader.getSystemResource(propertiesFile2);
                }
                if (object != null) {
                    configurationProperties.load(((URL)object).openStream());
                    System.out.println("[configuration loaded from classpath resource " + object + "]");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = System.getProperty("custom.props");
            if (object != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        Environment.loadProperties(string4);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((Hashtable)configurationProperties).putAll(System.getProperties());
            Environment.readValues();
            Environment.initLogging();
            if (logger == null) {
                throw new BAD_QOS("Logger is null!");
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read local jacorb properties.");
        }
    }

    private static final void loadProperties(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        configurationProperties.load(bufferedInputStream);
        bufferedInputStream.close();
        System.out.println("[configuration loaded from " + string + "]");
    }

    public static void addProperties(Properties properties) {
        if (configurationProperties == null) {
            configurationProperties = new Properties();
        }
        if (properties != null) {
            ((Hashtable)configurationProperties).putAll(properties);
            Environment.readValues();
        }
    }

    private static final void readValues() {
        _retries = Environment.getIntPropertyWithDefault("jacorb.retries", 5);
        _retry_interval = Environment.getIntPropertyWithDefault("jacorb.retry_interval", 500);
        _client_pending_reply_timeout = Environment.getIntPropertyWithDefault("jacorb.connection.client.pending_reply_timeout", 0);
        maxManagedBufSize = Environment.getIntPropertyWithDefault("jacorb.maxManagedBufSize", 18);
        compactTypecodes = Environment.getIntPropertyWithDefault("jacorb.compactTypecodes", 0);
        _locate_on_bind = Environment.isPropertyOn("jacorb.locate_on_bind");
        _cache_references = Environment.isPropertyOn("jacorb.reference_caching");
        _monitoring_on = Environment.isPropertyOn("jacorb.poa.monitoring");
        _use_imr = Environment.isPropertyOn("jacorb.use_imr");
        _use_imr_endpoint = Environment.isPropertyOn("jacorb.use_imr", "on");
        _thread_pool_max = Environment.getIntPropertyWithDefault("jacorb.poa.thread_pool_max", 20);
        _thread_pool_min = Environment.getIntPropertyWithDefault("jacorb.poa.thread_pool_min", 5);
        _queue_max = Environment.getIntPropertyWithDefault("jacorb.poa.queue_max", 100);
        _queue_min = Environment.getIntPropertyWithDefault("jacorb.poa.queue_min", 10);
        _queue_wait = Environment.isPropertyOn("jacorb.poa.queue_wait");
        _use_appligator_for_applets = Environment.isPropertyOn("jacorb.use_appligator_for_applets");
        _use_appligator_for_applications = Environment.isPropertyOn("jacorb.use_appligator_for_applications");
        _impl_name = Environment.getProperty("jacorb.implname", "").getBytes();
        _strict_check_on_tc_creation = Environment.isPropertyOn("jacorb.interop.strict_check_on_tc_creation", "on");
        _retry_on_failure = Environment.isPropertyOn("jacorb.connection.client.retry_on_failure");
        _useIndirection = !Environment.isPropertyOn("jacorb.interop.indirection_encoding_disable");
    }

    private static final void initLogging() {
        append = Environment.isPropertyOn("jacorb.logfile.append");
        if (configurationProperties.getProperty("logfile") != null) {
            logFileName = configurationProperties.getProperty("logfile");
        } else if (configurationProperties.getProperty("jacorb.logfile") != null) {
            logFileName = configurationProperties.getProperty("jacorb.logfile");
        }
        String string = configurationProperties.getProperty("jacorb.logfile.maxLogSize");
        if (string != null) {
            _max_log_size = Integer.parseInt(string);
        }
        if (logFileName != null && !logFileName.equals("") && logFileName.endsWith("$implname")) {
            logFileName = logFileName.substring(0, logFileName.length() - 9);
            logFileName = configurationProperties.getProperty("implname") != null ? logFileName + configurationProperties.getProperty("implname") : (configurationProperties.getProperty("jacorb.implname") != null ? logFileName + configurationProperties.getProperty("jacorb.implname") : logFileName + "log");
        }
        if (logger != null) {
            append = true;
        }
        String string2 = Environment.getProperty("jacorb.log.loggerFactory");
        Class clazz = null;
        try {
            clazz = string2 != null ? Environment.classForName(string2) : Environment.classForName(loggerFactoryClzName);
            loggerFactory = (LoggerFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (loggerFactory == null) {
            System.err.println("Configuration Error, could not create logger!");
        }
        if (logFileName != null) {
            try {
                logger = loggerFactory.getNamedLogger("jacorb", logFileName, _max_log_size);
            }
            catch (IOException iOException) {
                logger = loggerFactory.getNamedRootLogger("jacorb");
                if (logger.isErrorEnabled()) {
                    logger.error("Could not create logger with file target: " + logFileName + ", falling back to console log!");
                }
            }
        } else {
            logger = loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public static final boolean getStrictCheckOnTypecodeCreation() {
        return _strict_check_on_tc_creation;
    }

    public static final boolean isMonitoringOn() {
        return _monitoring_on;
    }

    public static final Logger getLogger() {
        return logger;
    }

    public static final long maxLogSize() {
        return _max_log_size;
    }

    public static final long currentLogSize() {
        return _current_log_size;
    }

    public static final int clientPendingReplyTimeout() {
        return _client_pending_reply_timeout;
    }

    public static final int noOfRetries() {
        return _retries;
    }

    public static final boolean locateOnBind() {
        return _locate_on_bind;
    }

    public static final boolean cacheReferences() {
        return _cache_references;
    }

    public static final boolean queueWait() {
        return _queue_wait;
    }

    public static final int queueMin() {
        return _queue_min;
    }

    public static final int queueMax() {
        return _queue_max;
    }

    public static final long retryInterval() {
        return _retry_interval;
    }

    public static final boolean useImR() {
        return _use_imr;
    }

    public static final boolean useImREndpoint() {
        return _use_imr_endpoint;
    }

    public static final int threadPoolMax() {
        return _thread_pool_max;
    }

    public static final int threadPoolMin() {
        return _thread_pool_min;
    }

    public static final byte[] implName() {
        return _impl_name;
    }

    public static final boolean useAppligator(boolean bl) {
        if (bl) {
            return _use_appligator_for_applets;
        }
        return _use_appligator_for_applications;
    }

    public static int getMaxManagedBufSize() {
        return maxManagedBufSize;
    }

    public static int getCompactTypecodes() {
        return compactTypecodes;
    }

    public static boolean getUseIndirection() {
        return _useIndirection;
    }

    public static String imrProxyHost() {
        return configurationProperties.getProperty("jacorb.imr.ior_proxy_host");
    }

    public static int imrProxyPort() {
        return Environment.getIntPropertyWithDefault("jacorb.imr.ior_proxy_port", -1);
    }

    public static String iorProxyHost() {
        return configurationProperties.getProperty("jacorb.ior_proxy_host");
    }

    public static int iorProxyPort() {
        return Environment.getIntPropertyWithDefault("jacorb.ior_proxy_port", -1);
    }

    public static int giopMinorVersion() {
        return Environment.getIntPropertyWithDefault("jacorb.giop_minor_version", 2);
    }

    public static boolean giopAdd_1_0_Profiles() {
        return Environment.isPropertyOn("jacorb.giop.add_1_0_profiles");
    }

    public static final boolean retryOnFailure() {
        return _retry_on_failure;
    }

    public static String getProperty(String string) {
        return configurationProperties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return configurationProperties.getProperty(string, string2);
    }

    public static boolean isPropertyOn(String string) {
        return Environment.isPropertyOn(string, "off");
    }

    public static boolean isPropertyOn(String string, String string2) {
        String string3 = configurationProperties.getProperty(string, string2);
        return "on".equals(string3);
    }

    public static long getLongProperty(String string, int n, long l) {
        String string2 = configurationProperties.getProperty(string);
        try {
            return Long.parseLong(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static long getLongProperty(String string, int n) {
        String string2 = configurationProperties.getProperty(string);
        try {
            return Long.parseLong(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BAD_QOS("Unable to create long from string >>" + string2 + "<<. " + "Please check property \"" + string + "\"");
        }
    }

    public static int getIntProperty(String string, int n) {
        String string2 = configurationProperties.getProperty(string);
        try {
            return Integer.parseInt(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BAD_QOS("Unable to create int from string >>" + string2 + "<<. " + "Please check property \"" + string + "\"");
        }
    }

    public static int getIntPropertyWithDefault(String string, int n) {
        String string2 = configurationProperties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_QOS("Unable to create int from string >>" + string2 + "<<. " + "Please check property \"" + string + "\"");
            }
        }
        return n;
    }

    public static Object getObjectProperty(String string) {
        String string2 = configurationProperties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            try {
                Class clazz = Environment.classForName(string2);
                return clazz.newInstance();
            }
            catch (Exception exception) {
                throw new BAD_QOS("Unable to build class from key >" + string + "<: " + exception);
            }
        }
        return null;
    }

    public static List getListProperty(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = configurationProperties.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public static boolean hasProperty(String string) {
        return ((Hashtable)configurationProperties).containsKey(string);
    }

    public static void setProperty(String string, String string2) {
        ((Hashtable)configurationProperties).put(string, string2);
    }

    public static String[] getPropertyValueList(String string) {
        String string2 = configurationProperties.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static final void readFromURL(URL uRL) {
        URL = uRL;
        System.out.println("Reading properties from url:" + URL.toString());
        try {
            configurationProperties = new Properties();
            configurationProperties.load(new BufferedInputStream(URL.openStream()));
        }
        catch (Exception exception) {
            System.out.println("Could not read properties from URL, reason: " + exception.toString());
        }
        Environment.readValues();
    }

    public static final byte[] serverId() {
        if (_server_id == null) {
            _server_id = String.valueOf((long)(Math.random() * 9.999999999E9)).getBytes();
        }
        return _server_id;
    }

    public static Vector getORBInitializers() {
        Enumeration<?> enumeration = configurationProperties.propertyNames();
        Vector vector = new Vector();
        String string = "org.omg.PortableInterceptor.ORBInitializerClass.";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = configurationProperties.getProperty(string2);
            if ((string3 == null || string3.length() == 0) && string2.length() > string.length()) {
                string3 = string2.substring(string.length());
            }
            if (string3 == null) continue;
            try {
                vector.addElement(Environment.classForName(string3).newInstance());
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Build: " + string3);
            }
            catch (Exception exception) {
                Debug.output(1, exception);
                Debug.output(1, "Unable to build ORBInitializer from >>" + string3 + "<<");
            }
        }
        return vector;
    }

    public static Hashtable getProperties(String string) {
        return Environment.getProperties(string, false);
    }

    public static Hashtable getProperties(String string, boolean bl) {
        if (bl && trimmedPrefixProps.containsKey(string)) {
            return (Hashtable)trimmedPrefixProps.get(string);
        }
        if (!bl && untrimmedPrefixProps.containsKey(string)) {
            return (Hashtable)untrimmedPrefixProps.get(string);
        }
        Enumeration<?> enumeration = configurationProperties.propertyNames();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            if (bl) {
                hashtable.put(string2.substring(string.length() + 1), configurationProperties.getProperty(string2));
                continue;
            }
            hashtable.put(string2, configurationProperties.getProperty(string2));
        }
        if (bl) {
            trimmedPrefixProps.put(string, hashtable);
        } else {
            untrimmedPrefixProps.put(string, hashtable);
        }
        return hashtable;
    }

    public static Class classForName(String string) throws ClassNotFoundException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            return Class.forName(string);
        }
    }

    public static LoggerFactory getLoggerFactory() {
        return loggerFactory;
    }

    public static Map createIdentityHashMap() {
        if (identityHashMapClass == null) {
            try {
                identityHashMapClass = Environment.classForName("java.util.IdentityHashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    identityHashMapClass = Environment.classForName("org.jacorb.util.IdentityHashMap");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new RuntimeException(classNotFoundException2.toString());
                }
            }
        }
        try {
            return (Map)identityHashMapClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    static {
        loggerFactory = null;
        logger = null;
        identityHashMapClass = null;
        _client_pending_reply_timeout = 0;
        _retries = 10;
        _retry_interval = 700L;
        maxManagedBufSize = 18;
        compactTypecodes = 0;
        _locate_on_bind = false;
        _use_imr = false;
        _use_imr_endpoint = true;
        _cache_references = false;
        logFileName = null;
        _max_log_size = 0L;
        append = false;
        _current_log_size = 0L;
        _useIndirection = false;
        _monitoring_on = false;
        _thread_pool_max = 20;
        _thread_pool_min = 10;
        _queue_max = 100;
        _queue_min = 10;
        _queue_wait = false;
        _use_appligator_for_applets = true;
        _use_appligator_for_applications = false;
        URL = null;
        _impl_name = null;
        _server_id = null;
        untrimmedPrefixProps = new HashMap();
        trimmedPrefixProps = new HashMap();
        _strict_check_on_tc_creation = false;
        _retry_on_failure = false;
        Environment.init();
    }
}

