/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.util.Date;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.util.Debug;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class Time {
    public static final long UNIX_OFFSET = 122192928000000000L;

    public static UtcT corbaTime() {
        return Time.corbaTime(System.currentTimeMillis());
    }

    public static UtcT corbaTime(long l) {
        UtcT utcT = new UtcT();
        utcT.time = l * 10000L + 122192928000000000L;
        utcT.tdf = 0;
        utcT.inacchi = 0;
        utcT.inacclo = 0;
        return utcT;
    }

    public static UtcT corbaTime(Date date) {
        return Time.corbaTime(date.getTime());
    }

    public static UtcT corbaFuture(long l) {
        if (l < 0L) {
            return null;
        }
        UtcT utcT = Time.corbaTime();
        utcT.time += l;
        return utcT;
    }

    public static long millisTo(UtcT utcT) {
        long l = (utcT.time - 122192928000000000L) / 10000L;
        if (utcT.tdf != 0) {
            l -= (long)(utcT.tdf * 60000);
        }
        return l - System.currentTimeMillis();
    }

    public static boolean hasPassed(UtcT utcT) {
        if (utcT != null) {
            return Time.millisTo(utcT) < 0L;
        }
        return false;
    }

    public static UtcT earliest(UtcT utcT, UtcT utcT2) {
        if (utcT == null) {
            if (utcT2 == null) {
                return null;
            }
            return utcT2;
        }
        if (utcT2 == null || utcT.time <= utcT2.time) {
            return utcT;
        }
        return utcT2;
    }

    public static byte[] toCDR(UtcT utcT) {
        byte[] byArray = new byte[25];
        CDROutputStream cDROutputStream = new CDROutputStream(byArray);
        cDROutputStream.beginEncapsulatedArray();
        UtcTHelper.write(cDROutputStream, utcT);
        return byArray;
    }

    public static UtcT fromCDR(byte[] byArray) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        cDRInputStream.openEncapsulatedArray();
        return UtcTHelper.read(cDRInputStream);
    }

    public static void waitFor(UtcT utcT) {
        long l;
        if (utcT != null && (l = Time.millisTo(utcT)) > 0L) {
            Object object;
            Object object2 = object = new Object();
            synchronized (object2) {
                try {
                    object.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    Debug.output(4, "interrupted while waiting on timer");
                }
            }
        }
    }
}

