/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.threadpool;

import java.util.LinkedList;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ConsumerTie;

public class ThreadPool {
    private int max_threads = 0;
    private int max_idle_threads = 0;
    private int total_threads = 0;
    private int idle_threads = 0;
    private LinkedList job_queue = null;
    private ConsumerFactory factory = null;
    private Logger logger = Debug.getNamedLogger("jacorb.util.tpool");

    protected synchronized Object getJob() {
        if (this.idle_threads >= this.max_idle_threads) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] Telling thread to exit (too many idle)");
            }
            --this.total_threads;
            return null;
        }
        ++this.idle_threads;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] added idle thread");
        }
        while (this.job_queue.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] job queue empty");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Debug.output(3, interruptedException);
            }
        }
        --this.idle_threads;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] removed idle thread (job scheduled)");
        }
        return this.job_queue.removeFirst();
    }

    public synchronized void putJob(Object object) {
        this.job_queue.add(object);
        this.notifyAll();
        if (this.idle_threads == 0 && this.total_threads < this.max_threads) {
            this.createNewThread();
        }
    }

    private final void createNewThread() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] creating new thread");
        }
        Thread thread = new Thread(new ConsumerTie(this, this.factory.create()));
        thread.setDaemon(true);
        thread.start();
        ++this.total_threads;
    }

    public ThreadPool(ConsumerFactory consumerFactory) {
        this(new LinkedList(), consumerFactory, 10, 10);
    }

    public ThreadPool(ConsumerFactory consumerFactory, int n, int n2) {
        this(new LinkedList(), consumerFactory, n, n2);
    }

    private ThreadPool(LinkedList linkedList, ConsumerFactory consumerFactory, int n, int n2) {
        this.job_queue = linkedList;
        this.factory = consumerFactory;
        this.max_threads = n;
        this.max_idle_threads = n2;
    }
}

