/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf('.');
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf('$');
    private static Map primitiveWrapperMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        char[] chars = className.toCharArray();
        int lastDot = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '.') {
                lastDot = i + 1;
            } else if (chars[i] == '$') {
                chars[i] = 46;
            }
            ++i;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }

    public static String getPackageName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        return ClassUtils.getPackageName(cls.getName());
    }

    public static String getPackageName(String className) {
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("The class name must not be empty");
        }
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i);
    }

    public static List getAllSuperclasses(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        Class superclass = cls.getSuperclass();
        while (superclass != null) {
            classes.add(superclass);
            superclass = superclass.getSuperclass();
        }
        return classes;
    }

    public static List getAllInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Class> list = new ArrayList<Class>();
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                List superInterfaces = ClassUtils.getAllInterfaces(interfaces[i]);
                Iterator it = superInterfaces.iterator();
                while (it.hasNext()) {
                    Class intface = (Class)it.next();
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
                ++i;
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static List convertClassNamesToClasses(List classNames) {
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList(classNames.size());
        Iterator it = classNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception ex) {
                classes.add(null);
            }
        }
        return classes;
    }

    public static List convertClassesToClassNames(List classes) {
        if (classes == null) {
            return null;
        }
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class cls = (Class)it.next();
            if (cls == null) {
                classNames.add(null);
                continue;
            }
            classNames.add(cls.getName());
        }
        return classNames;
    }

    public static boolean isAssignable(Class[] classArray, Class[] toClassArray) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int i = 0;
        while (i < classArray.length) {
            if (!ClassUtils.isAssignable(classArray[i], toClassArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAssignable(Class cls, Class toClass) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class primitiveToWrapper(Class cls) {
        Class convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = (Class)primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static boolean isInnerClass(Class cls) {
        if (cls == null) {
            return false;
        }
        return cls.getName().indexOf(36) >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveWrapperMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveWrapperMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveWrapperMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveWrapperMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveWrapperMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveWrapperMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveWrapperMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float);
    }
}

