/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class Tokenizer
implements ListIterator {
    public static final Matcher COMMA_MATCHER = new CharMatcher(',');
    public static final Matcher DOUBLE_QUOTE_MATCHER = new CharMatcher('\"');
    public static final Matcher SPACES_MATCHER = new TrimMatcher();
    public static final Matcher NONE_MATCHER = new NoMatcher();
    private char[] chars;
    private String[] tokens;
    private int tokenPos;
    private Matcher delim = COMMA_MATCHER;
    private Matcher quote = DOUBLE_QUOTE_MATCHER;
    private Matcher ignored = SPACES_MATCHER;
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = false;

    public Tokenizer(String input) {
        this(input.toCharArray());
    }

    public Tokenizer(String input, char delim) {
        this(input.toCharArray(), delim);
    }

    public Tokenizer(String input, CharSetMatcher delim) {
        this(input.toCharArray(), delim);
    }

    public Tokenizer(String input, char delim, char quote) {
        this(input.toCharArray(), delim, quote);
    }

    public Tokenizer(String input, CharSetMatcher delim, CharSetMatcher quote) {
        this(input.toCharArray(), delim, quote);
    }

    public Tokenizer(char[] input) {
        this.chars = (char[])input.clone();
        this.tokenPos = 0;
    }

    public Tokenizer(char[] input, char delim) {
        this(input);
        this.setDelimiterChar(delim);
    }

    public Tokenizer(char[] input, CharSetMatcher delim) {
        this(input);
        this.setDelimiterMatcher(delim);
    }

    public Tokenizer(char[] input, char delim, char quote) {
        this(input, delim);
        this.setQuoteChar(quote);
    }

    public Tokenizer(char[] input, CharSetMatcher delim, CharSetMatcher quote) {
        this(input, delim);
        this.setQuoteMatcher(quote);
    }

    public int size() {
        this.tokenize();
        return this.tokens.length;
    }

    public String nextToken() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        return null;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        return null;
    }

    public String[] getAllTokens() {
        this.tokenize();
        return (String[])this.tokens.clone();
    }

    public void reset() {
        this.tokenPos = 0;
        this.tokens = null;
    }

    public boolean hasNext() {
        this.tokenize();
        return this.tokenPos < this.tokens.length;
    }

    public Object next() {
        return this.nextToken();
    }

    public int nextIndex() {
        return this.tokenPos;
    }

    public boolean hasPrevious() {
        this.tokenize();
        return this.tokenPos > 0;
    }

    public Object previous() {
        return this.previousToken();
    }

    public int previousIndex() {
        return this.tokenPos - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    public void set(Object obj) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    public void add(Object obj) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void tokenize() {
        if (this.tokens == null) {
            this.tokens = this.readTokens();
        }
    }

    private String[] readTokens() {
        int len = this.chars.length;
        char[] cbuf = new char[len];
        StringBuffer token = new StringBuffer();
        int start = 0;
        ArrayList tokens = new ArrayList();
        String tok = null;
        while (start < len) {
            start = this.readNextToken(start, cbuf, token);
            tok = token.toString();
            this.addToken(tokens, tok);
            token.setLength(0);
            if (start != len || !this.delim.isMatch(this.chars[start - 1])) continue;
            this.addToken(tokens, new String());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private void addToken(List list, String tok) {
        if (tok == null || tok.length() == 0) {
            if (this.ignoreEmptyTokens) {
                return;
            }
            if (this.emptyAsNull) {
                tok = null;
            }
        }
        list.add(tok);
    }

    private int readNextToken(int start, char[] cbuf, StringBuffer token) {
        token.setLength(0);
        int len = this.chars.length;
        while (start < len && this.ignored.isMatch(this.chars[start]) && !this.delim.isMatch(this.chars[start]) && !this.quote.isMatch(this.chars[start])) {
            ++start;
        }
        start = this.delim.isMatch(this.chars[start]) ? this.readEmpty(start, token) : (this.quote.isMatch(this.chars[start]) ? this.readQuoted(start, cbuf, token) : this.readUnquoted(start, token));
        return start;
    }

    private int readQuoted(int start, char[] cbuf, StringBuffer token) {
        int cbufcnt = 0;
        int nd = start + 1;
        boolean done = false;
        boolean quoting = true;
        int len = this.chars.length;
        while (nd < len && !done) {
            if (quoting) {
                if (this.quote.isMatch(this.chars[nd]) && nd + 1 < len && this.chars[nd + 1] == this.chars[nd]) {
                    cbuf[cbufcnt++] = this.chars[nd];
                    ++nd;
                } else if (this.quote.isMatch(this.chars[nd])) {
                    quoting = false;
                } else {
                    cbuf[cbufcnt++] = this.chars[nd];
                }
                ++nd;
                continue;
            }
            if (this.delim.isMatch(this.chars[nd])) {
                done = true;
                continue;
            }
            if (this.quote.isMatch(this.chars[nd])) {
                quoting = true;
            } else {
                cbuf[cbufcnt++] = this.chars[nd];
            }
            ++nd;
        }
        token.append(cbuf, 0, cbufcnt);
        return nd + 1;
    }

    private int readUnquoted(int start, StringBuffer token) {
        int len = this.chars.length;
        int nd = start + 1;
        while (nd < len && !this.delim.isMatch(this.chars[nd])) {
            ++nd;
        }
        token.append(this.chars, start, Math.min(nd, len) - start);
        return nd + 1;
    }

    private int readEmpty(int start, StringBuffer token) {
        token.setLength(0);
        return start + 1;
    }

    public Matcher getDelimiterMatcher() {
        return this.delim;
    }

    public void setDelimiterMatcher(Matcher delim) {
        if (delim != null) {
            this.delim = delim;
        }
    }

    public void setDelimiterChar(char delim) {
        this.setDelimiterMatcher(new CharMatcher(delim));
    }

    public Matcher getQuoteMatcher() {
        return this.quote;
    }

    public void setQuoteMatcher(Matcher quote) {
        if (quote != null) {
            this.quote = quote;
        }
    }

    public void setQuoteChar(char quote) {
        this.setQuoteMatcher(new CharMatcher(quote));
    }

    public Matcher getIgnoredMatcher() {
        return this.ignored;
    }

    public void setIgnoredMatcher(Matcher ignored) {
        if (ignored != null) {
            this.ignored = ignored;
        }
    }

    public void setIgnoredChar(char ignored) {
        this.setIgnoredMatcher(new CharMatcher(ignored));
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public void setEmptyTokenAsNull(boolean emptyAsNull) {
        this.emptyAsNull = emptyAsNull;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public void setIgnoreEmptyTokens(boolean ignoreEmptyTokens) {
        this.ignoreEmptyTokens = ignoreEmptyTokens;
    }

    static final class TrimMatcher
    implements Matcher {
        TrimMatcher() {
        }

        public boolean isMatch(char ch) {
            return ch <= ' ';
        }
    }

    static final class NoMatcher
    implements Matcher {
        NoMatcher() {
        }

        public boolean isMatch(char ch) {
            return false;
        }
    }

    public static final class CharMatcher
    implements Matcher {
        private char ch;

        public CharMatcher(char ch) {
            this.ch = ch;
        }

        public char getChar() {
            return this.ch;
        }

        public boolean isMatch(char ch) {
            return this.ch == ch;
        }
    }

    public static final class CharSetMatcher
    implements Matcher {
        private char[] chars;

        public CharSetMatcher(char[] chars) {
            this.chars = (char[])chars.clone();
            Arrays.sort(this.chars);
        }

        public CharSetMatcher(String chars) {
            this(chars.toCharArray());
        }

        public char[] getChars() {
            return (char[])this.chars.clone();
        }

        public boolean isMatch(char c) {
            return Arrays.binarySearch(this.chars, c) >= 0;
        }
    }

    public static interface Matcher {
        public boolean isMatch(char var1);
    }
}

