/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import org.apache.commons.lang.time.FastDateFormat;

class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    public static final FastDateFormat ISO_EXTENDED_FORMAT = FastDateFormat.getInstance("'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'");

    public static String formatISO(long millis) {
        int hours = (int)(millis / 3600000L);
        int minutes = (int)((millis -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((millis -= (long)(minutes * 60000)) / 1000L);
        int milliseconds = (int)(millis -= (long)(seconds * 1000));
        StringBuffer buf = new StringBuffer(32);
        buf.append(hours);
        buf.append(':');
        buf.append((char)(minutes / 10 + 48));
        buf.append((char)(minutes % 10 + 48));
        buf.append(':');
        buf.append((char)(seconds / 10 + 48));
        buf.append((char)(seconds % 10 + 48));
        buf.append('.');
        if (milliseconds < 10) {
            buf.append('0').append('0');
        } else if (milliseconds < 100) {
            buf.append('0');
        }
        buf.append(milliseconds);
        return buf.toString();
    }

    public static String formatWords(long millis, boolean supressLeadingZeroElements, boolean supressTrailingZeroElements) {
        long[] values = new long[]{millis / 86400000L, millis / 3600000L % 24L, millis / 60000L % 60L, millis / 1000L % 60L};
        String[] fieldsOne = new String[]{" day ", " hour ", " minute ", " second"};
        String[] fieldsPlural = new String[]{" days ", " hours ", " minutes ", " seconds"};
        StringBuffer buf = new StringBuffer(64);
        boolean valueOutput = false;
        int i = 0;
        while (i < 4) {
            long value = values[i];
            if (value == 0L) {
                if (valueOutput) {
                    if (!supressTrailingZeroElements) {
                        buf.append('0').append(fieldsPlural[i]);
                    }
                } else if (!supressLeadingZeroElements) {
                    buf.append('0').append(fieldsPlural[i]);
                }
            } else if (value == 1L) {
                valueOutput = true;
                buf.append('1').append(fieldsOne[i]);
            } else {
                valueOutput = true;
                buf.append(value).append(fieldsPlural[i]);
            }
            ++i;
        }
        return buf.toString().trim();
    }
}

