/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.util;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang.util.LongIdentifierFactory;
import org.apache.commons.lang.util.StringIdentifierFactory;

public class IdentifierUtils {
    public static final LongIdentifierFactory LONG_IDENTIFIER_FACTORY = new LongNumericIdentifierFactory(true, 0L);
    public static final StringIdentifierFactory STRING_NUMERIC_IDENTIFIER_FACTORY = new StringNumericIdentifierFactory(true, 0L);
    public static final StringIdentifierFactory STRING_ALPHANUMERIC_IDENTIFIER_FACTORY = new StringAlphanumericIdentifierFactory(true, 15);
    public static final StringIdentifierFactory STRING_SESSION_IDENTIFIER_FACTORY = new StringSessionIdentifierFactory();

    public static Long nextLongIdentifier() {
        return LONG_IDENTIFIER_FACTORY.nextLongIdentifier();
    }

    public static LongIdentifierFactory longIdentifierFactory() {
        return new LongNumericIdentifierFactory(true, 0L);
    }

    public static LongIdentifierFactory longIdentifierFactory(boolean wrap, long initialValue) {
        return new LongNumericIdentifierFactory(wrap, initialValue);
    }

    public static String nextStringNumericIdentifier() {
        return STRING_NUMERIC_IDENTIFIER_FACTORY.nextStringIdentifier();
    }

    public static StringIdentifierFactory stringNumericIdentifierFactory() {
        return new StringNumericIdentifierFactory(true, 0L);
    }

    public static StringIdentifierFactory stringNumericIdentifierFactory(boolean wrap, long initialValue) {
        return new StringNumericIdentifierFactory(wrap, initialValue);
    }

    public static String nextStringAlphanumericIdentifier() {
        return STRING_ALPHANUMERIC_IDENTIFIER_FACTORY.nextStringIdentifier();
    }

    public static StringIdentifierFactory stringAlphanumericIdentifierFactory() {
        return new StringAlphanumericIdentifierFactory(true, 15);
    }

    public static StringIdentifierFactory stringAlphanumericIdentifierFactory(boolean wrap, int size) {
        return new StringAlphanumericIdentifierFactory(wrap, size);
    }

    public static String nextStringSessionIdentifier() {
        return STRING_SESSION_IDENTIFIER_FACTORY.nextStringIdentifier();
    }

    public static StringIdentifierFactory stringSessionIdentifierFactory() {
        return new StringSessionIdentifierFactory();
    }

    private static class StringSessionIdentifierFactory
    implements StringIdentifierFactory,
    Serializable {
        private static final long MAX_RANDOM_LEN = 2176782336L;
        private static final long MAX_TIME_SECTION_LEN = 46656L;
        private static final long TIC_DIFFERENCE = 2000L;
        private int counter = 0;
        private long lastTimeValue = 0L;
        private Random randomizer = new Random();

        private StringSessionIdentifierFactory() {
        }

        public Object nextIdentifier() {
            return this.nextStringIdentifier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String nextStringIdentifier() {
            long currentRandom = this.randomizer.nextLong();
            if (currentRandom < 0L) {
                currentRandom = -currentRandom;
            }
            currentRandom %= 2176782336L;
            currentRandom += 2176782336L;
            long currentTimeValue = 0L;
            int currentCount = 0;
            StringSessionIdentifierFactory stringSessionIdentifierFactory = this;
            synchronized (stringSessionIdentifierFactory) {
                currentTimeValue = System.currentTimeMillis() / 2000L;
                currentTimeValue %= 46656L;
                if (this.lastTimeValue != (currentTimeValue += 46656L)) {
                    this.lastTimeValue = currentTimeValue;
                    this.counter = 0;
                }
                currentCount = this.counter++;
            }
            StringBuffer id = new StringBuffer(15);
            id.append(Long.toString(currentRandom, 36).substring(1));
            id.append(Long.toString(currentTimeValue, 36).substring(1));
            id.append(Long.toString(currentCount, 36));
            return id.toString();
        }
    }

    private static class StringAlphanumericIdentifierFactory
    implements StringIdentifierFactory,
    Serializable {
        private final boolean wrap;
        private char[] count = null;

        private StringAlphanumericIdentifierFactory(boolean wrap, int size) {
            this.wrap = wrap;
            if (size < 1) {
                throw new IllegalArgumentException("The size must be at least one");
            }
            this.count = new char[size];
            int i = 0;
            while (i < size) {
                this.count[i] = 48;
                ++i;
            }
        }

        public Object nextIdentifier() {
            return this.nextStringIdentifier();
        }

        public synchronized String nextStringIdentifier() {
            int i = this.count.length - 1;
            while (i >= 0) {
                switch (this.count[i]) {
                    case 'z': {
                        this.count[i] = 48;
                        if (i != 0 || this.wrap) break;
                        throw new IllegalStateException("The maximum number of identifiers has been reached");
                    }
                    case '9': {
                        this.count[i] = 97;
                        i = -1;
                        break;
                    }
                    default: {
                        int n = i;
                        this.count[n] = (char)(this.count[n] + '\u0001');
                        i = -1;
                    }
                }
                --i;
            }
            return new String(this.count);
        }
    }

    private static class StringNumericIdentifierFactory
    implements StringIdentifierFactory,
    Serializable {
        private final boolean wrap;
        private long count = 0L;

        private StringNumericIdentifierFactory(boolean wrap, long initialValue) {
            this.wrap = wrap;
            this.count = initialValue;
        }

        public Object nextIdentifier() {
            return this.nextStringIdentifier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String nextStringIdentifier() {
            long value = 0L;
            if (this.wrap) {
                StringNumericIdentifierFactory stringNumericIdentifierFactory = this;
                synchronized (stringNumericIdentifierFactory) {
                    value = this.count++;
                }
            }
            StringNumericIdentifierFactory stringNumericIdentifierFactory = this;
            synchronized (stringNumericIdentifierFactory) {
                if (this.count == Long.MAX_VALUE) {
                    throw new IllegalStateException("The maximum number of identifiers has been reached");
                }
                value = this.count++;
            }
            return Long.toString(value);
        }
    }

    private static class LongNumericIdentifierFactory
    implements LongIdentifierFactory,
    Serializable {
        private final boolean wrap;
        private long count = 0L;

        private LongNumericIdentifierFactory(boolean wrap, long initialValue) {
            this.wrap = wrap;
            this.count = initialValue;
        }

        public Object nextIdentifier() {
            return this.nextLongIdentifier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long nextLongIdentifier() {
            long value = 0L;
            if (this.wrap) {
                LongNumericIdentifierFactory longNumericIdentifierFactory = this;
                synchronized (longNumericIdentifierFactory) {
                    value = this.count++;
                }
            }
            LongNumericIdentifierFactory longNumericIdentifierFactory = this;
            synchronized (longNumericIdentifierFactory) {
                if (this.count == Long.MAX_VALUE) {
                    throw new IllegalStateException("The maximum number of identifiers has been reached");
                }
                value = this.count++;
            }
            return new Long(value);
        }
    }
}

