/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.TraceManager;
import com.sun.jdmk.TraceNotification;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import javax.management.Notification;
import javax.management.NotificationListener;

public class TraceListener
implements NotificationListener {
    protected PrintStream out;
    protected boolean needTobeClosed = false;
    protected boolean formated = false;

    public TraceListener() {
        this.out = System.out;
    }

    public TraceListener(PrintStream printStream) throws IllegalArgumentException {
        if (printStream == null) {
            throw new IllegalArgumentException("An PrintStream object should be specified.");
        }
        this.out = printStream;
    }

    public TraceListener(String string) throws IOException {
        this.out = new PrintStream(new FileOutputStream(string, true));
        this.needTobeClosed = true;
    }

    public void setFormated(boolean bl) {
        this.formated = bl;
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof TraceNotification) {
            TraceNotification traceNotification = (TraceNotification)notification;
            if (this.formated) {
                this.out.print("\nGlobal sequence number: " + traceNotification.globalSequenceNumber + "     Sequence number: " + traceNotification.sequenceNumber + "\n" + "Level: " + TraceManager.getLevel(traceNotification.level) + "     Type: " + TraceManager.getType(traceNotification.type) + "\n" + "Class  Name: " + traceNotification.className + "\n" + "Method Name: " + traceNotification.methodName + "\n");
                this.out.println("Thread name: " + traceNotification.threadName);
                this.out.println("TimeStamp: " + TraceListener.getTime(traceNotification.getTimeStamp()));
                if (traceNotification.exception != null) {
                    traceNotification.exception.printStackTrace(this.out);
                    this.out.println();
                }
                if (traceNotification.info != null) {
                    this.out.println("Information: " + traceNotification.info);
                }
            } else {
                this.out.print("(" + traceNotification.className + " " + traceNotification.methodName + " " + traceNotification.threadName + " " + TraceListener.getTime(traceNotification.getTimeStamp()) + ") ");
                if (traceNotification.exception != null) {
                    traceNotification.exception.printStackTrace(this.out);
                    this.out.println();
                }
                if (traceNotification.info != null) {
                    this.out.println(traceNotification.info);
                }
            }
        }
    }

    public void setFile(String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string, true));
        if (this.needTobeClosed) {
            this.out.close();
        }
        this.out = printStream;
        this.needTobeClosed = true;
    }

    private static String getTime(long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(new Date(l).toString(), " ");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        long l2 = l % 1000L;
        if (l2 < 10L) {
            return stringTokenizer.nextToken().toString() + ":00" + l2;
        }
        if (l2 < 100L) {
            return stringTokenizer.nextToken().toString() + ":0" + l2;
        }
        return stringTokenizer.nextToken().toString() + ":" + l % 1000L;
    }
}

