/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.contrib.Desktop;
import CH.ifa.draw.contrib.DesktopEvent;
import CH.ifa.draw.contrib.DesktopListener;
import CH.ifa.draw.contrib.JPanelDesktop;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureAttributeConstant;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.NullTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SelectAllCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.RedoCommand;
import CH.ifa.draw.util.SerializationStorageFormat;
import CH.ifa.draw.util.StandardStorageFormat;
import CH.ifa.draw.util.StandardVersionControlStrategy;
import CH.ifa.draw.util.StorageFormat;
import CH.ifa.draw.util.StorageFormatManager;
import CH.ifa.draw.util.UndoCommand;
import CH.ifa.draw.util.UndoManager;
import CH.ifa.draw.util.UndoableCommand;
import CH.ifa.draw.util.VersionControlStrategy;
import CH.ifa.draw.util.VersionManagement;
import CH.ifa.draw.util.VersionRequester;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class DrawApplication
extends JFrame
implements DrawingEditor,
PaletteListener,
VersionRequester {
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    private DrawingView fView;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private String fApplicationName;
    private StorageFormatManager fStorageFormatManager;
    private UndoManager myUndoManager;
    protected static String fgUntitled = "untitled";
    private final EventListenerList listenerList = new EventListenerList();
    private DesktopListener fDesktopListener;
    private Desktop fDesktop;
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    protected static int winCount = 0;
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    static /* synthetic */ Class class$CH$ifa$draw$util$CommandMenu;
    static /* synthetic */ Class class$CH$ifa$draw$framework$ViewChangeListener;
    static /* synthetic */ Class class$CH$ifa$draw$application$DrawApplication;

    public DrawApplication() {
        this("JHotDraw");
    }

    public DrawApplication(String title) {
        super(title);
        this.setApplicationName(title);
        ++winCount;
    }

    protected DrawApplication createApplication() {
        return new DrawApplication();
    }

    public void newView() {
        if (this.view() == null) {
            return;
        }
        DrawApplication window = this.createApplication();
        window.open(this.view());
        if (this.view().drawing().getTitle() != null) {
            window.setDrawingTitle(this.view().drawing().getTitle() + " (View)");
        } else {
            window.setDrawingTitle(this.getDefaultDrawingTitle() + " (View)");
        }
    }

    public void newWindow(Drawing initialDrawing) {
        DrawApplication window = this.createApplication();
        if (initialDrawing == null) {
            window.open();
        } else {
            window.open(window.createDrawingView(initialDrawing));
        }
    }

    public final void newWindow() {
        this.newWindow(this.createDrawing());
    }

    public void open() {
        this.open(this.createInitialDrawingView());
    }

    protected void open(final DrawingView newDrawingView) {
        this.getVersionControlStrategy().assertCompatibleVersion();
        this.setUndoManager(new UndoManager());
        this.setIconkit(this.createIconkit());
        this.getContentPane().setLayout(new BorderLayout());
        this.setStatusLine(this.createStatusLine());
        this.getContentPane().add((Component)this.getStatusLine(), "South");
        this.setTool(new NullTool(this), "");
        this.setView(newDrawingView);
        JToolBar tools = this.createToolPalette();
        this.createTools(tools);
        JPanel activePanel = new JPanel();
        activePanel.setAlignmentX(0.0f);
        activePanel.setAlignmentY(0.0f);
        activePanel.setLayout(new BorderLayout());
        activePanel.add((Component)tools, "North");
        this.setDesktopListener(this.createDesktopListener());
        this.setDesktop(this.createDesktop());
        activePanel.add((Component)((Object)this.getDesktop()), "Center");
        this.getContentPane().add((Component)activePanel, "Center");
        JMenuBar mb = new JMenuBar();
        this.createMenus(mb);
        this.setJMenuBar(mb);
        Dimension d = this.defaultSize();
        if (d.width > mb.getPreferredSize().width) {
            this.setSize(d.width, d.height);
        } else {
            this.setSize(mb.getPreferredSize().width, d.height);
        }
        this.addListeners();
        this.setStorageFormatManager(this.createStorageFormatManager());
        Runnable r = new Runnable(){

            public void run() {
                if (newDrawingView.isInteractive()) {
                    DrawApplication.this.getDesktop().addToDesktop(newDrawingView, 0);
                }
                DrawApplication.this.toolDone();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException ie) {
                System.err.println(ie.getMessage());
                this.exit();
            }
            catch (InvocationTargetException ite) {
                System.err.println(ite.getMessage());
                this.exit();
            }
        } else {
            r.run();
        }
        this.setVisible(true);
        this.toolDone();
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                DrawApplication.this.exit();
            }
        });
    }

    protected void createMenus(JMenuBar mb) {
        this.addMenuIfPossible(mb, this.createFileMenu());
        this.addMenuIfPossible(mb, this.createEditMenu());
        this.addMenuIfPossible(mb, this.createAlignmentMenu());
        this.addMenuIfPossible(mb, this.createAttributesMenu());
        this.addMenuIfPossible(mb, this.createDebugMenu());
    }

    protected void addMenuIfPossible(JMenuBar mb, JMenu newMenu) {
        if (newMenu != null) {
            mb.add(newMenu);
        }
    }

    protected JMenu createFileMenu() {
        CommandMenu menu = new CommandMenu("File");
        AbstractCommand cmd = new AbstractCommand("New", this, false){

            public void execute() {
                DrawApplication.this.promptNew();
            }
        };
        menu.add(cmd, new MenuShortcut(110));
        cmd = new AbstractCommand("Open...", this, false){

            public void execute() {
                DrawApplication.this.promptOpen();
            }
        };
        menu.add(cmd, new MenuShortcut(111));
        cmd = new AbstractCommand("Save As...", this, true){

            public void execute() {
                DrawApplication.this.promptSaveAs();
            }
        };
        menu.add(cmd, new MenuShortcut(115));
        menu.addSeparator();
        cmd = new AbstractCommand("Print...", this, true){

            public void execute() {
                DrawApplication.this.print();
            }
        };
        menu.add(cmd, new MenuShortcut(112));
        menu.addSeparator();
        cmd = new AbstractCommand("Exit", this, true){

            public void execute() {
                DrawApplication.this.exit();
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        menu.add(new UndoableCommand(new SelectAllCommand("Select All", this)), new MenuShortcut(97));
        menu.addSeparator();
        menu.add(new UndoableCommand(new CutCommand("Cut", this)), new MenuShortcut(120));
        menu.add(new CopyCommand("Copy", this), new MenuShortcut(99));
        menu.add(new UndoableCommand(new PasteCommand("Paste", this)), new MenuShortcut(118));
        menu.addSeparator();
        menu.add(new UndoableCommand(new DuplicateCommand("Duplicate", this)), new MenuShortcut(100));
        menu.add(new UndoableCommand(new DeleteCommand("Delete", this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new GroupCommand("Group", this)));
        menu.add(new UndoableCommand(new UngroupCommand("Ungroup", this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new SendToBackCommand("Send to Back", this)));
        menu.add(new UndoableCommand(new BringToFrontCommand("Bring to Front", this)));
        menu.addSeparator();
        menu.add(new UndoCommand("Undo Command", this));
        menu.add(new RedoCommand("Redo Command", this));
        return menu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu menu = new CommandMenu("Align");
        menu.addCheckItem(new ToggleGridCommand("Toggle Snap to Grid", (DrawingEditor)this, new Point(4, 4)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.LEFTS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.CENTERS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.RIGHTS, (DrawingEditor)this)));
        menu.addSeparator();
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.TOPS, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.MIDDLES, (DrawingEditor)this)));
        menu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.BOTTOMS, (DrawingEditor)this)));
        return menu;
    }

    protected JMenu createDebugMenu() {
        CommandMenu menu = new CommandMenu("Debug");
        AbstractCommand cmd = new AbstractCommand("Simple Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new SimpleUpdateStrategy());
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("Buffered Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new BufferedUpdateStrategy());
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", FigureAttributeConstant.FILL_COLOR));
        menu.add(this.createColorMenu("Pen Color", FigureAttributeConstant.FRAME_COLOR));
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", FigureAttributeConstant.TEXT_COLOR));
        return menu;
    }

    protected JMenu createColorMenu(String title, FigureAttributeConstant attribute) {
        CommandMenu menu = new CommandMenu(title);
        int i = 0;
        while (i < ColorMap.size()) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this)));
            ++i;
        }
        return menu;
    }

    protected JMenu createArrowMenu() {
        FigureAttributeConstant arrowMode = FigureAttributeConstant.ARROW_MODE;
        CommandMenu menu = new CommandMenu("Arrow");
        menu.add(new UndoableCommand(new ChangeAttributeCommand("none", arrowMode, new Integer(0), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at Start", arrowMode, new Integer(1), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at End", arrowMode, new Integer(2), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("at Both", arrowMode, new Integer(3), this)));
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        int i = 0;
        while (i < fonts.length) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(fonts[i], FigureAttributeConstant.FONT_NAME, fonts[i], this)));
            ++i;
        }
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        FigureAttributeConstant fontStyle = FigureAttributeConstant.FONT_STYLE;
        CommandMenu menu = new CommandMenu("Font Style");
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Plain", fontStyle, new Integer(0), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Italic", fontStyle, new Integer(2), this)));
        menu.add(new UndoableCommand(new ChangeAttributeCommand("Bold", fontStyle, new Integer(1), this)));
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = new CommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        int i = 0;
        while (i < sizes.length) {
            menu.add(new UndoableCommand(new ChangeAttributeCommand(Integer.toString(sizes[i]), FigureAttributeConstant.FONT_SIZE, new Integer(sizes[i]), this)));
            ++i;
        }
        return menu;
    }

    public JMenu createLookAndFeelMenu() {
        CommandMenu menu = new CommandMenu("Look'n'Feel");
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lafs.length) {
            final String lnfClassName = lafs[i].getClassName();
            AbstractCommand cmd = new AbstractCommand(lafs[i].getName(), this){

                public void execute() {
                    DrawApplication.this.newLookAndFeel(lnfClassName);
                }
            };
            menu.add(cmd);
            ++i;
        }
        return menu;
    }

    protected JToolBar createToolPalette() {
        JToolBar palette = new JToolBar();
        palette.setBackground(Color.lightGray);
        return palette;
    }

    protected void createTools(JToolBar palette) {
        this.setDefaultTool(this.createDefaultTool());
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    protected Tool createDefaultTool() {
        return this.createSelectionTool();
    }

    protected void setDefaultTool(Tool newDefaultTool) {
        this.fDefaultToolButton = newDefaultTool != null ? this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", newDefaultTool) : null;
    }

    public Tool getDefaultTool() {
        if (this.fDefaultToolButton != null) {
            return this.fDefaultToolButton.tool();
        }
        return null;
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected DrawingView createDrawingView() {
        DrawingView createdDrawingView = this.createDrawingView(this.createDrawing());
        createdDrawingView.drawing().setTitle(this.getDefaultDrawingTitle());
        return createdDrawingView;
    }

    protected DrawingView createDrawingView(Drawing newDrawing) {
        Dimension d = this.getDrawingViewSize();
        StandardDrawingView newDrawingView = new StandardDrawingView(this, d.width, d.height);
        newDrawingView.setDrawing(newDrawing);
        return newDrawingView;
    }

    protected DrawingView createInitialDrawingView() {
        return this.createDrawingView();
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(800, 800);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected Desktop createDesktop() {
        return new JPanelDesktop(this);
    }

    protected void setDesktop(Desktop newDesktop) {
        newDesktop.addDesktopListener(this.getDesktopListener());
        this.fDesktop = newDesktop;
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new StandardStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        storageFormatManager.addStorageFormat(new SerializationStorageFormat());
        return storageFormatManager;
    }

    protected final void setStorageFormatManager(StorageFormatManager newStorageFormatManager) {
        this.fStorageFormatManager = newStorageFormatManager;
    }

    public StorageFormatManager getStorageFormatManager() {
        return this.fStorageFormatManager;
    }

    protected Dimension defaultSize() {
        return new Dimension(600, 450);
    }

    protected JTextField createStatusLine() {
        JTextField field = new JTextField("No Tool", 40);
        field.setBackground(Color.white);
        field.setEditable(false);
        return field;
    }

    private void setStatusLine(JTextField newStatusLine) {
        this.fStatusLine = newStatusLine;
    }

    protected JTextField getStatusLine() {
        return this.fStatusLine;
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean inside) {
        ToolButton toolButton = (ToolButton)paletteButton;
        if (inside) {
            this.showStatus(toolButton.name());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    protected void setView(DrawingView newView) {
        DrawingView oldView = this.fView;
        this.fView = newView;
        this.fireViewSelectionChangedEvent(oldView, this.view());
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public void toolDone() {
        System.out.println("ToolDone");
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void figureSelectionChanged(DrawingView view) {
        this.checkCommandMenus();
    }

    protected void checkCommandMenus() {
        JMenuBar mb = this.getJMenuBar();
        int x = 0;
        while (x < mb.getMenuCount()) {
            JMenu jm;
            if ((class$CH$ifa$draw$util$CommandMenu == null ? DrawApplication.class$("CH.ifa.draw.util.CommandMenu") : class$CH$ifa$draw$util$CommandMenu).isInstance(jm = mb.getMenu(x))) {
                this.checkCommandMenu((CommandMenu)jm);
            }
            ++x;
        }
    }

    protected void checkCommandMenu(CommandMenu cm) {
        cm.checkEnabled();
        int y = 0;
        while (y < cm.getItemCount()) {
            JMenuItem jmi;
            if ((class$CH$ifa$draw$util$CommandMenu == null ? DrawApplication.class$("CH.ifa.draw.util.CommandMenu") : class$CH$ifa$draw$util$CommandMenu).isInstance(jmi = cm.getItem(y))) {
                this.checkCommandMenu((CommandMenu)jmi);
            }
            ++y;
        }
    }

    public void addViewChangeListener(ViewChangeListener vsl) {
        this.listenerList.add(class$CH$ifa$draw$framework$ViewChangeListener == null ? (class$CH$ifa$draw$framework$ViewChangeListener = DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener")) : class$CH$ifa$draw$framework$ViewChangeListener, vsl);
    }

    public void removeViewChangeListener(ViewChangeListener vsl) {
        this.listenerList.remove(class$CH$ifa$draw$framework$ViewChangeListener == null ? (class$CH$ifa$draw$framework$ViewChangeListener = DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener")) : class$CH$ifa$draw$framework$ViewChangeListener, vsl);
    }

    protected void fireViewSelectionChangedEvent(DrawingView oldView, DrawingView newView) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) {
                vsl = (ViewChangeListener)listeners[i + 1];
                vsl.viewSelectionChanged(oldView, newView);
            }
            i -= 2;
        }
    }

    protected void fireViewCreatedEvent(DrawingView view) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) {
                vsl = (ViewChangeListener)listeners[i + 1];
                vsl.viewCreated(view);
            }
            i -= 2;
        }
    }

    protected void fireViewDestroyingEvent(DrawingView view) {
        Object[] listeners = this.listenerList.getListenerList();
        ViewChangeListener vsl = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$framework$ViewChangeListener == null ? DrawApplication.class$("CH.ifa.draw.framework.ViewChangeListener") : class$CH$ifa$draw$framework$ViewChangeListener)) {
                vsl = (ViewChangeListener)listeners[i + 1];
                vsl.viewDestroying(view);
            }
            i -= 2;
        }
    }

    public void showStatus(String string) {
        this.getStatusLine().setText(string);
    }

    public void setTool(Tool t, String name) {
        if (this.tool() != null && this.tool().isActive()) {
            this.tool().deactivate();
        }
        this.fTool = t;
        if (this.tool() != null) {
            this.showStatus(name);
            this.tool().activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void exit() {
        this.destroy();
        this.setVisible(false);
        this.dispose();
        if (--winCount == 0) {
            System.exit(0);
        }
    }

    protected void destroy() {
    }

    public void promptNew() {
        this.newWindow(this.createDrawing());
    }

    public void promptOpen() {
        this.toolDone();
        JFileChooser openDialog = this.createOpenFileChooser();
        this.getStorageFormatManager().registerFileFilters(openDialog);
        if (openDialog.showOpenDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(openDialog.getFileFilter());
            if (foundFormat != null) {
                this.loadDrawing(foundFormat, openDialog.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + openDialog.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAs() {
        if (this.view() != null) {
            this.toolDone();
            JFileChooser saveDialog = this.createSaveFileChooser();
            this.getStorageFormatManager().registerFileFilters(saveDialog);
            if (saveDialog.showSaveDialog(this) == 0) {
                StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
                if (foundFormat != null) {
                    this.saveDrawing(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
                } else {
                    this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
                }
            }
        }
    }

    protected JFileChooser createOpenFileChooser() {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setDialogTitle("Open File...");
        return openDialog;
    }

    protected JFileChooser createSaveFileChooser() {
        JFileChooser saveDialog = new JFileChooser();
        saveDialog.setDialogTitle("Save File...");
        return saveDialog;
    }

    public void print() {
        this.tool().deactivate();
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Drawing", null);
        if (printJob != null) {
            Graphics pg = printJob.getGraphics();
            if (pg != null) {
                ((StandardDrawingView)this.view()).printAll(pg);
                pg.dispose();
            }
            printJob.end();
        }
        this.tool().activate();
    }

    protected void saveDrawing(StorageFormat storeFormat, String file) {
        if (this.view() == null) {
            return;
        }
        try {
            String name = storeFormat.store(file, this.view().drawing());
            this.view().drawing().setTitle(name);
            this.setDrawingTitle(name);
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    protected void loadDrawing(StorageFormat restoreFormat, String file) {
        block3: {
            try {
                Drawing restoredDrawing = restoreFormat.restore(file);
                if (restoredDrawing != null) {
                    restoredDrawing.setTitle(file);
                    this.newWindow(restoredDrawing);
                    break block3;
                }
                this.showStatus("Unknown file type: could not open file '" + file + "'");
            }
            catch (IOException e) {
                this.showStatus("Error: " + e);
            }
        }
    }

    private void newLookAndFeel(String landf) {
        try {
            UIManager.setLookAndFeel(landf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void setDrawingTitle(String drawingTitle) {
        if (this.getDefaultDrawingTitle().equals(drawingTitle)) {
            this.setTitle(this.getApplicationName());
        } else {
            this.setTitle(this.getApplicationName() + " - " + drawingTitle);
        }
    }

    protected String getDrawingTitle() {
        return this.view().drawing().getTitle();
    }

    public void setApplicationName(String applicationName) {
        this.fApplicationName = applicationName;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }

    protected void setUndoManager(UndoManager newUndoManager) {
        this.myUndoManager = newUndoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected VersionControlStrategy getVersionControlStrategy() {
        return new StandardVersionControlStrategy(this);
    }

    public String[] getRequiredVersions() {
        String[] requiredVersions = new String[]{VersionManagement.getPackageVersion((class$CH$ifa$draw$application$DrawApplication == null ? (class$CH$ifa$draw$application$DrawApplication = DrawApplication.class$("CH.ifa.draw.application.DrawApplication")) : class$CH$ifa$draw$application$DrawApplication).getPackage())};
        return requiredVersions;
    }

    public String getDefaultDrawingTitle() {
        return fgUntitled;
    }

    protected DesktopListener getDesktopListener() {
        return this.fDesktopListener;
    }

    protected void setDesktopListener(DesktopListener desktopPaneListener) {
        this.fDesktopListener = desktopPaneListener;
    }

    protected DesktopListener createDesktopListener() {
        return new DesktopListener(){

            public void drawingViewAdded(DesktopEvent dpe) {
                DrawingView dv = dpe.getDrawingView();
                DrawApplication.this.fireViewCreatedEvent(dv);
            }

            public void drawingViewRemoved(DesktopEvent dpe) {
                DrawingView dv = dpe.getDrawingView();
                DrawApplication.this.getUndoManager().clearUndos(dv);
                DrawApplication.this.getUndoManager().clearRedos(dv);
                DrawApplication.this.fireViewDestroyingEvent(dv);
                DrawApplication.this.checkCommandMenus();
            }

            public void drawingViewSelected(DesktopEvent dpe) {
                DrawingView dv = dpe.getDrawingView();
                if (dv != null && dv.drawing() != null) {
                    dv.unfreezeView();
                }
                DrawApplication.this.setView(dv);
            }
        };
    }

    protected Iconkit createIconkit() {
        return new Iconkit(this);
    }

    protected void setIconkit(Iconkit newIconkit) {
        this.fIconkit = newIconkit;
    }

    protected Iconkit getIconkit() {
        return this.fIconkit;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

