/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.CTXCommandMenu;
import CH.ifa.draw.contrib.CommandMenuItem;
import CH.ifa.draw.contrib.MDIDesktopPane;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class CTXWindowMenu
extends CTXCommandMenu {
    private MDIDesktopPane desktop;
    private CommandMenuItem cascadeCommand;
    private CommandMenuItem tileHCommand;
    private CommandMenuItem tileVCommand;
    private CommandMenuItem arrangeHCommand;
    private CommandMenuItem arrangeVCommand;
    private int staticItems;

    public CTXWindowMenu(String newText, MDIDesktopPane newDesktop, DrawingEditor newEditor) {
        super(newText);
        this.desktop = newDesktop;
        this.cascadeCommand = new CommandMenuItem(new AbstractCommand("Cascade", newEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.cascadeFrames();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.tileHCommand = new CommandMenuItem(new AbstractCommand("Tile Horizontally", newEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.tileFramesHorizontally();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.tileVCommand = new CommandMenuItem(new AbstractCommand("Tile Vertically", newEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.tileFramesVertically();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.arrangeHCommand = new CommandMenuItem(new AbstractCommand("Arrange Horizontally", newEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.arrangeFramesHorizontally();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.arrangeVCommand = new CommandMenuItem(new AbstractCommand("Arrange Vertically", newEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.arrangeFramesVertically();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                CTXWindowMenu.this.removeWindowsList();
            }

            public void menuSelected(MenuEvent e) {
                CTXWindowMenu.this.buildChildMenus();
            }
        });
        this.add(this.cascadeCommand);
        this.add(this.tileHCommand);
        this.add(this.tileVCommand);
        this.add(this.arrangeHCommand);
        this.add(this.arrangeVCommand);
        this.staticItems = 5;
    }

    protected void removeWindowsList() {
        while (this.getItemCount() > this.staticItems) {
            this.remove(this.staticItems);
        }
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.cascadeCommand.setEnabled(array.length > 0);
        this.tileHCommand.setEnabled(array.length > 0);
        this.tileVCommand.setEnabled(array.length > 0);
        this.arrangeHCommand.setEnabled(array.length > 0);
        this.arrangeVCommand.setEnabled(array.length > 0);
        if (array.length == 0) {
            return;
        }
        this.addSeparator();
        int i = 0;
        while (i < array.length) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
            ++i;
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

