/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.CreationTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CompositeFigureCreationTool
extends CreationTool {
    private CompositeFigure myContainerFigure;

    public CompositeFigureCreationTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        Figure figure = this.drawing().findFigure(e.getX(), e.getY());
        if (figure != null) {
            if ((figure = figure.getDecoratedFigure()) instanceof CompositeFigure) {
                this.setContainerFigure((CompositeFigure)figure);
                this.setCreatedFigure(this.createFigure());
                this.setAddedFigure(this.getContainerFigure().add(this.getCreatedFigure()));
                this.getAddedFigure().displayBox(new Point(x, y), new Point(x, y));
            } else {
                this.toolDone();
            }
        } else {
            this.toolDone();
        }
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        if (this.getContainerFigure() != null && !this.getContainerFigure().containsPoint(e.getX(), e.getY())) {
            this.toolDone();
        } else {
            super.mouseMove(e, x, y);
        }
    }

    protected void setContainerFigure(CompositeFigure newContainerFigure) {
        this.myContainerFigure = newContainerFigure;
    }

    public CompositeFigure getContainerFigure() {
        return this.myContainerFigure;
    }

    protected void toolDone() {
        this.setCreatedFigure(null);
        this.setAddedFigure(null);
        this.setContainerFigure(null);
        this.editor().toolDone();
    }
}

