/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PopupMenuFigureSelection;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.SelectionTool;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public class CustomSelectionTool
extends SelectionTool {
    public CustomSelectionTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e, x, y);
        } else {
            super.mouseDown(e, x, y);
            this.handleMouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (!e.isPopupTrigger()) {
            super.mouseDrag(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (e.isPopupTrigger()) {
            this.handlePopupMenu(e, x, y);
            super.mouseUp(e, x, y);
        } else if (e.getClickCount() == 2) {
            super.mouseUp(e, x, y);
            this.handleMouseDoubleClick(e, x, y);
        } else {
            super.mouseUp(e, x, y);
            this.handleMouseUp(e, x, y);
            this.handleMouseClick(e, x, y);
        }
    }

    protected void handleMouseDown(MouseEvent e, int x, int y) {
    }

    protected void handleMouseUp(MouseEvent e, int x, int y) {
    }

    protected void handleMouseClick(MouseEvent e, int x, int y) {
    }

    protected void handleMouseDoubleClick(MouseEvent e, int x, int y) {
    }

    protected void handlePopupMenu(MouseEvent e, int x, int y) {
        Figure figure = this.drawing().findFigure(e.getX(), e.getY());
        if (figure != null) {
            Object attribute = figure.getAttribute("POPUP_MENU");
            if (attribute == null) {
                figure = this.drawing().findFigureInside(e.getX(), e.getY());
            }
            if (figure != null) {
                this.showPopupMenu(figure, e.getX(), e.getY(), e.getComponent());
            }
        }
    }

    protected void showPopupMenu(Figure figure, int x, int y, Component comp) {
        Object attribute = figure.getAttribute("POPUP_MENU");
        if (attribute != null && attribute instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)attribute;
            if (popup instanceof PopupMenuFigureSelection) {
                ((PopupMenuFigureSelection)((Object)popup)).setSelectedFigure(figure);
            }
            Point newLocation = new Point(x, y);
            this.adjustOffsets(comp.getParent(), newLocation);
            popup.setLocation(newLocation);
            popup.setInvoker(comp);
            popup.setVisible(true);
        }
    }

    private void adjustOffsets(Component comp, Point offsetPoint) {
        if (comp != null) {
            Point compLocation = comp.getLocation();
            offsetPoint.translate(compLocation.x, compLocation.y);
            this.adjustOffsets(comp.getParent(), offsetPoint);
        }
    }
}

