/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Desktop;
import CH.ifa.draw.contrib.DesktopEvent;
import CH.ifa.draw.contrib.DesktopListener;
import CH.ifa.draw.contrib.Helper;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.util.CollectionsFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DesktopEventService {
    private final EventListenerList listenerList = new EventListenerList();
    private DrawingView mySelectedView;
    private Container myContainer;
    private Desktop myDesktop;
    static /* synthetic */ Class class$CH$ifa$draw$contrib$DesktopListener;

    public DesktopEventService(Desktop newDesktop, Container newContainer) {
        this.setDesktop(newDesktop);
        this.setContainer(newContainer);
        this.getContainer().addContainerListener(this.createComponentListener());
    }

    private void setDesktop(Desktop newDesktop) {
        this.myDesktop = newDesktop;
    }

    protected Desktop getDesktop() {
        return this.myDesktop;
    }

    private void setContainer(Container newContainer) {
        this.myContainer = newContainer;
    }

    protected Container getContainer() {
        return this.myContainer;
    }

    public void addComponent(Component newComponent) {
        this.getContainer().add(newComponent);
    }

    public void removeComponent(DrawingView dv) {
        Component[] comps = this.getContainer().getComponents();
        int x = 0;
        while (x < comps.length) {
            if (dv == Helper.getDrawingView(comps[x])) {
                this.getContainer().remove(comps[x]);
                break;
            }
            ++x;
        }
    }

    public void removeAllComponents() {
        this.getContainer().removeAll();
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.listenerList.add(class$CH$ifa$draw$contrib$DesktopListener == null ? (class$CH$ifa$draw$contrib$DesktopListener = DesktopEventService.class$("CH.ifa.draw.contrib.DesktopListener")) : class$CH$ifa$draw$contrib$DesktopListener, dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.listenerList.remove(class$CH$ifa$draw$contrib$DesktopListener == null ? (class$CH$ifa$draw$contrib$DesktopListener = DesktopEventService.class$("CH.ifa.draw.contrib.DesktopListener")) : class$CH$ifa$draw$contrib$DesktopListener, dpl);
    }

    protected void fireDrawingViewAddedEvent(DrawingView dv) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = this.createDesktopEvent(this.getActiveDrawingView(), dv);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? DesktopEventService.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewAdded(dpe);
            }
            i -= 2;
        }
    }

    protected void fireDrawingViewRemovedEvent(DrawingView dv) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = this.createDesktopEvent(this.getActiveDrawingView(), dv);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? DesktopEventService.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewRemoved(dpe);
            }
            i -= 2;
        }
    }

    protected void fireDrawingViewSelectedEvent(DrawingView oldView, DrawingView newView) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = this.createDesktopEvent(oldView, newView);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? DesktopEventService.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewSelected(dpe);
            }
            i -= 2;
        }
    }

    protected DesktopEvent createDesktopEvent(DrawingView oldView, DrawingView newView) {
        return new DesktopEvent(this.getDesktop(), newView, oldView);
    }

    public DrawingView[] getDrawingViews(Component[] comps) {
        List al = CollectionsFactory.current().createList();
        int x = 0;
        while (x < comps.length) {
            DrawingView dv = Helper.getDrawingView(comps[x]);
            if (dv != null) {
                al.add(dv);
            }
            ++x;
        }
        DrawingView[] dvs = new DrawingView[al.size()];
        al.toArray(dvs);
        return dvs;
    }

    public DrawingView getActiveDrawingView() {
        return this.mySelectedView;
    }

    protected void setActiveDrawingView(DrawingView newActiveDrawingView) {
        this.mySelectedView = newActiveDrawingView;
    }

    protected ContainerListener createComponentListener() {
        return new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                DrawingView dv = Helper.getDrawingView((Container)e.getChild());
                DrawingView oldView = DesktopEventService.this.getActiveDrawingView();
                if (dv != null) {
                    DesktopEventService.this.fireDrawingViewAddedEvent(dv);
                    DesktopEventService.this.setActiveDrawingView(dv);
                    DesktopEventService.this.fireDrawingViewSelectedEvent(oldView, DesktopEventService.this.getActiveDrawingView());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                DrawingView dv = Helper.getDrawingView((Container)e.getChild());
                if (dv != null) {
                    DrawingView oldView = DesktopEventService.this.getActiveDrawingView();
                    DesktopEventService.this.setActiveDrawingView(NullDrawingView.getManagedDrawingView(oldView.editor()));
                    DesktopEventService.this.fireDrawingViewSelectedEvent(oldView, DesktopEventService.this.getActiveDrawingView());
                    DesktopEventService.this.fireDrawingViewRemovedEvent(dv);
                }
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

