/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Layoutable;
import CH.ifa.draw.contrib.Layouter;
import CH.ifa.draw.contrib.StandardLayouter;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureAttributeConstant;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.HandleEnumeration;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.HandleEnumerator;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;

public class GraphicalCompositeFigure
extends CompositeFigure
implements Layoutable {
    private Figure myPresentationFigure;
    private Layouter myLayouter;
    private static final long serialVersionUID = 1265742491024232713L;

    public GraphicalCompositeFigure() {
        this(new RectangleFigure());
    }

    public GraphicalCompositeFigure(Figure newPresentationFigure) {
        this.setPresentationFigure(newPresentationFigure);
        this.initialize();
    }

    protected void initialize() {
        if (this.getLayouter() != null) {
            this.setLayouter(this.getLayouter().create(this));
        } else {
            this.setLayouter(new StandardLayouter(this));
        }
    }

    public Object clone() {
        Object cloneObject = super.clone();
        ((GraphicalCompositeFigure)cloneObject).initialize();
        return cloneObject;
    }

    public Rectangle displayBox() {
        return this.getPresentationFigure().displayBox();
    }

    public void basicDisplayBox(Point origin, Point corner) {
        Rectangle r = this.getLayouter().layout(origin, corner);
        this.getPresentationFigure().basicDisplayBox(r.getLocation(), new Point((int)r.getMaxX(), (int)r.getMaxY()));
    }

    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        this.getPresentationFigure().moveBy(dx, dy);
    }

    public void update() {
        this.willChange();
        this.layout();
        this.change();
        this.changed();
    }

    public void draw(Graphics g) {
        this.getPresentationFigure().draw(g);
        super.draw(g);
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, handles);
        return new HandleEnumerator(handles);
    }

    public Object getAttribute(String name) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(attributeConstant);
        }
        return super.getAttribute(attributeConstant);
    }

    public void setAttribute(String name, Object value) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(name, value);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(attributeConstant, value);
        } else {
            super.setAttribute(attributeConstant, value);
        }
    }

    public void setPresentationFigure(Figure newPresentationFigure) {
        this.myPresentationFigure = newPresentationFigure;
    }

    public Figure getPresentationFigure() {
        return this.myPresentationFigure;
    }

    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle r = this.getLayouter().calculateLayout(this.displayBox().getLocation(), this.displayBox().getLocation());
            this.displayBox(r.getLocation(), new Point(r.x + r.width, r.y + r.height));
        }
    }

    public void setLayouter(Layouter newLayouter) {
        this.myLayouter = newLayouter;
    }

    public Layouter getLayouter() {
        return this.myLayouter;
    }

    protected void change() {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            if (this.includes(e.getFigure())) {
                Rectangle r = this.invalidateRectangle(this.displayBox());
                this.listener().figureRequestRemove(new FigureChangeEvent(this, r, e));
            } else {
                super.figureRequestRemove(e);
            }
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setPresentationFigure((Figure)dr.readStorable());
        this.setLayouter((Layouter)dr.readStorable());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getPresentationFigure());
        dw.writeStorable(this.getLayouter());
    }
}

