/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.Desktop;
import CH.ifa.draw.contrib.DesktopEventService;
import CH.ifa.draw.contrib.DesktopListener;
import CH.ifa.draw.framework.DrawingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelDesktop
extends JPanel
implements Desktop {
    private DesktopEventService myDesktopEventService;
    private DrawApplication myDrawApplication;

    public JPanelDesktop(DrawApplication newDrawApplication) {
        this.setDrawApplication(newDrawApplication);
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
    }

    protected Component createContents(DrawingView dv) {
        JScrollPane sp = new JScrollPane((Component)((Object)dv));
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        sp.setAlignmentX(0.0f);
        String applicationTitle = dv.drawing().getTitle() == null ? this.getDrawApplication().getApplicationName() + " - " + this.getDrawApplication().getDefaultDrawingTitle() : this.getDrawApplication().getApplicationName() + " - " + dv.drawing().getTitle();
        sp.setName(applicationTitle);
        return sp;
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView dv, int location) {
        this.getDesktopEventService().addComponent(this.createContents(dv));
        this.getContainer().validate();
    }

    public void removeFromDesktop(DrawingView dv, int location) {
        this.getDesktopEventService().removeComponent(dv);
        this.getContainer().validate();
    }

    public void removeAllFromDesktop(int location) {
        this.getDesktopEventService().removeAllComponents();
        this.getContainer().validate();
    }

    public DrawingView[] getAllFromDesktop(int location) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().addDesktopListener(dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().removeDesktopListener(dpl);
    }

    private Container getContainer() {
        return this;
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService newDesktopEventService) {
        this.myDesktopEventService = newDesktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    private void setDrawApplication(DrawApplication newDrawApplication) {
        this.myDrawApplication = newDrawApplication;
    }

    protected DrawApplication getDrawApplication() {
        return this.myDrawApplication;
    }

    public void updateTitle(String newDrawingTitle) {
        this.setName(newDrawingTitle);
    }
}

