/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.Desktop;
import CH.ifa.draw.contrib.DesktopEvent;
import CH.ifa.draw.contrib.DesktopListener;
import CH.ifa.draw.contrib.Helper;
import CH.ifa.draw.contrib.MDIDesktopManager;
import CH.ifa.draw.framework.DrawingView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MDIDesktopPane
extends JDesktopPane
implements Desktop {
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager;
    private DrawApplication myDrawApplication;
    private DrawingView selectedView;
    protected InternalFrameListener internalFrameListener = new InternalFrameAdapter(){

        public void internalFrameOpened(InternalFrameEvent e) {
            DrawingView dv = Helper.getDrawingView(e.getInternalFrame());
            MDIDesktopPane.this.fireDrawingViewAddedEvent(dv);
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            DrawingView dv = Helper.getDrawingView(e.getInternalFrame());
            if (MDIDesktopPane.this.getComponentCount() == 0) {
                MDIDesktopPane.this.setActiveDrawingView(null);
                MDIDesktopPane.this.fireDrawingViewSelectedEvent(MDIDesktopPane.this.selectedView);
            }
            MDIDesktopPane.this.fireDrawingViewRemovedEvent(dv);
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            DrawingView dv = Helper.getDrawingView(e.getInternalFrame());
            MDIDesktopPane.this.setActiveDrawingView(dv);
            MDIDesktopPane.this.fireDrawingViewSelectedEvent(MDIDesktopPane.this.selectedView);
        }
    };
    static /* synthetic */ Class class$CH$ifa$draw$contrib$DesktopListener;

    public MDIDesktopPane(DrawApplication newDrawApplication) {
        this.setDrawApplication(newDrawApplication);
        this.manager = new MDIDesktopManager(this);
        this.setDesktopManager(this.manager);
        this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
        this.setAlignmentX(0.0f);
    }

    private void fireDrawingViewAddedEvent(DrawingView dv) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? MDIDesktopPane.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                if (dpe == null) {
                    dpe = new DesktopEvent(this, dv);
                }
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewAdded(dpe);
            }
            i -= 2;
        }
    }

    private void fireDrawingViewRemovedEvent(DrawingView dv) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? MDIDesktopPane.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                if (dpe == null) {
                    dpe = new DesktopEvent(this, dv);
                }
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewRemoved(dpe);
            }
            i -= 2;
        }
    }

    private void fireDrawingViewSelectedEvent(DrawingView dv) {
        Object[] listeners = this.listenerList.getListenerList();
        DesktopEvent dpe = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$CH$ifa$draw$contrib$DesktopListener == null ? MDIDesktopPane.class$("CH.ifa.draw.contrib.DesktopListener") : class$CH$ifa$draw$contrib$DesktopListener)) {
                if (dpe == null) {
                    dpe = new DesktopEvent(this, dv);
                }
                DesktopListener dpl = (DesktopListener)listeners[i + 1];
                dpl.drawingViewSelected(dpe);
            }
            i -= 2;
        }
    }

    protected Component createContents(DrawingView dv) {
        JScrollPane sp = new JScrollPane((Component)((Object)dv));
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        sp.setAlignmentX(0.0f);
        String applicationTitle = dv.drawing().getTitle() == null ? this.getDrawApplication().getApplicationName() + " - " + this.getDrawApplication().getDefaultDrawingTitle() : this.getDrawApplication().getApplicationName() + " - " + dv.drawing().getTitle();
        JInternalFrame internalFrame = new JInternalFrame(applicationTitle, true, true, true, true);
        internalFrame.setName(applicationTitle);
        internalFrame.getContentPane().add(sp);
        internalFrame.setSize(200, 200);
        return internalFrame;
    }

    public DrawingView getActiveDrawingView() {
        return this.selectedView;
    }

    protected void setActiveDrawingView(DrawingView newSelectedView) {
        this.selectedView = newSelectedView;
    }

    public void updateTitle(String newDrawingTitle) {
        this.getSelectedFrame().setTitle(newDrawingTitle);
    }

    public void addToDesktop(DrawingView dv, int location) {
        JInternalFrame frame = (JInternalFrame)this.createContents(dv);
        JInternalFrame[] array = this.getAllFrames();
        Point p = null;
        frame.addInternalFrameListener(this.internalFrameListener);
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (array.length > 0) {
            p = array[0].getLocation();
            p.x += FRAME_OFFSET;
            p.y += FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        frame.setLocation(p.x, p.y);
        if (frame.isResizable()) {
            int w = this.getWidth() - this.getWidth() / 3;
            int h = this.getHeight() - this.getHeight() / 3;
            if ((double)w < frame.getMinimumSize().getWidth()) {
                w = (int)frame.getMinimumSize().getWidth();
            }
            if ((double)h < frame.getMinimumSize().getHeight()) {
                h = (int)frame.getMinimumSize().getHeight();
            }
            frame.setSize(w, h);
        }
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
    }

    public void removeFromDesktop(DrawingView dv, int location) {
        Component[] comps = this.getComponents();
        int x = 0;
        while (x < comps.length) {
            if (dv == Helper.getDrawingView(comps[x])) {
                ((JInternalFrame)comps[x]).dispose();
                break;
            }
            ++x;
        }
        this.checkDesktopSize();
    }

    public void removeAllFromDesktop(int location) {
        JInternalFrame[] jifs = this.getAllFrames();
        int x = 0;
        while (x < jifs.length) {
            jifs[x].dispose();
            ++x;
        }
    }

    public DrawingView[] getAllFromDesktop(int location) {
        Component[] comps = this.getComponents();
        ArrayList<DrawingView> al = new ArrayList<DrawingView>();
        int x = 0;
        while (x < comps.length) {
            DrawingView dv = Helper.getDrawingView(comps[x]);
            if (dv != null) {
                al.add(dv);
            }
            ++x;
        }
        DrawingView[] dvs = new DrawingView[al.size()];
        al.toArray(dvs);
        return dvs;
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.listenerList.add(class$CH$ifa$draw$contrib$DesktopListener == null ? (class$CH$ifa$draw$contrib$DesktopListener = MDIDesktopPane.class$("CH.ifa.draw.contrib.DesktopListener")) : class$CH$ifa$draw$contrib$DesktopListener, dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.listenerList.remove(class$CH$ifa$draw$contrib$DesktopListener == null ? (class$CH$ifa$draw$contrib$DesktopListener = MDIDesktopPane.class$("CH.ifa.draw.contrib.DesktopListener")) : class$CH$ifa$draw$contrib$DesktopListener, dpl);
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        int i = allFrames.length - 1;
        while (i >= 0) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(x, y, frameWidth, frameHeight);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
            --i;
        }
        this.checkDesktopSize();
    }

    public void tileFrames() {
        this.tileFramesHorizontally();
    }

    public void tileFramesHorizontally() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        int i = 0;
        while (i < allFrames.length) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(0, y, this.getBounds().width, frameHeight);
            y += frameHeight;
            ++i;
        }
        this.checkDesktopSize();
    }

    public void tileFramesVertically() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int frameWidth = this.getBounds().width / allFrames.length;
        int x = 0;
        int i = 0;
        while (i < allFrames.length) {
            try {
                allFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[i].setBounds(x, 0, frameWidth, this.getBounds().height);
            x += frameWidth;
            ++i;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesVertically() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int vertFrames = (int)Math.floor(Math.sqrt(allFrames.length));
        int horFrames = (int)Math.ceil(Math.sqrt(allFrames.length));
        int frameWidth = this.getBounds().width / horFrames;
        int frameHeight = this.getBounds().height / vertFrames;
        int x = 0;
        int y = 0;
        int frameIdx = 0;
        int horCnt = 0;
        while (horCnt < horFrames - 1) {
            y = 0;
            int vertCnt = 0;
            while (vertCnt < vertFrames) {
                try {
                    allFrames[frameIdx].setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
                ++frameIdx;
                y += frameHeight;
                ++vertCnt;
            }
            x += frameWidth;
            ++horCnt;
        }
        frameHeight = this.getBounds().height / (allFrames.length - frameIdx);
        y = 0;
        while (frameIdx < allFrames.length) {
            try {
                allFrames[frameIdx].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
            y += frameHeight;
            ++frameIdx;
        }
        this.checkDesktopSize();
    }

    public void arrangeFramesHorizontally() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames.length == 0) {
            return;
        }
        this.manager.setNormalSize();
        int vertFrames = (int)Math.ceil(Math.sqrt(allFrames.length));
        int horFrames = (int)Math.floor(Math.sqrt(allFrames.length));
        int frameWidth = this.getBounds().width / horFrames;
        int frameHeight = this.getBounds().height / vertFrames;
        int x = 0;
        int y = 0;
        int frameIdx = 0;
        int vertCnt = 0;
        while (vertCnt < vertFrames - 1) {
            x = 0;
            int horCnt = 0;
            while (horCnt < horFrames) {
                try {
                    allFrames[frameIdx].setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
                ++frameIdx;
                x += frameWidth;
                ++horCnt;
            }
            y += frameHeight;
            ++vertCnt;
        }
        frameWidth = this.getBounds().width / (allFrames.length - frameIdx);
        x = 0;
        while (frameIdx < allFrames.length) {
            try {
                allFrames[frameIdx].setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            allFrames[frameIdx].setBounds(x, y, frameWidth, frameHeight);
            x += frameWidth;
            ++frameIdx;
        }
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
        this.setBounds(0, 0, d.width, d.height);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    private void setDrawApplication(DrawApplication newDrawApplication) {
        this.myDrawApplication = newDrawApplication;
    }

    protected DrawApplication getDrawApplication() {
        return this.myDrawApplication;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

