/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MiniMapView
extends JComponent {
    private JScrollPane m_subject;
    private DrawingView myMappedDrawingView;
    private SubjectListener m_subjectListener;
    private DrawingChangeListener myDrawingChangeListener;
    private Color m_viewBoxColor = Color.red;

    public MiniMapView(DrawingView newMappedDrawingView, JScrollPane subject) {
        this.m_subjectListener = new SubjectListener();
        this.setSubject(subject);
        this.setMappedDrawingView(newMappedDrawingView);
        this.myDrawingChangeListener = new MappedDrawingChangeListener();
        this.getMappedDrawingView().drawing().addDrawingChangeListener(this.myDrawingChangeListener);
        MouseListener ml = new MouseListener();
        this.addMouseListener(new MouseListener());
        this.addMouseMotionListener(ml);
    }

    protected void setMappedDrawingView(DrawingView newMappedDrawingView) {
        this.myMappedDrawingView = newMappedDrawingView;
    }

    public DrawingView getMappedDrawingView() {
        return this.myMappedDrawingView;
    }

    protected void setSubject(JScrollPane subject) {
        if (this.m_subject != null) {
            this.m_subject.getViewport().removeChangeListener(this.m_subjectListener);
        }
        this.m_subject = subject;
        if (this.m_subject != null) {
            this.m_subject.getViewport().addChangeListener(this.m_subjectListener);
        }
        this.repaint();
    }

    public JScrollPane getSubject() {
        return this.m_subject;
    }

    public Color getViewBowColor() {
        return this.m_viewBoxColor;
    }

    public void setViewBoxColor(Color c) {
        this.m_viewBoxColor = c;
        this.repaint();
    }

    protected Component getMappedComponent() {
        return (Component)((Object)this.getMappedDrawingView());
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Component mappedComponent = this.getMappedComponent();
        AffineTransform at = this.getViewToMiniMapTransform(mappedComponent);
        g2d.transform(at);
        this.getMappedDrawingView().drawAll(g2d);
        this.drawViewRectangle(g2d, this.getViewRectangle());
    }

    protected void drawViewRectangle(Graphics2D g2d, Rectangle viewPortRectangle) {
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        g2d.setTransform(at);
        g2d.setColor(this.m_viewBoxColor);
        g2d.draw(viewPortRectangle);
    }

    protected AffineTransform getViewToMiniMapTransform(Component mappedComponent) {
        double scaleX = (double)this.getWidth() / (double)mappedComponent.getWidth();
        double scaleY = (double)this.getHeight() / (double)mappedComponent.getHeight();
        AffineTransform at = this.getInverseSubjectTransform();
        at.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        return at;
    }

    protected AffineTransform getInverseSubjectTransform() {
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        return at;
    }

    protected Rectangle getViewRectangle() {
        Rectangle visiblePortion = this.m_subject.getViewportBorderBounds();
        Point upperLeftViewPos = this.m_subject.getViewport().getViewPosition();
        double[] srcRecCorners = new double[4];
        double[] dstRecCorners = new double[4];
        srcRecCorners[0] = (double)upperLeftViewPos.x + visiblePortion.getX();
        srcRecCorners[1] = (double)upperLeftViewPos.y + visiblePortion.getY();
        srcRecCorners[2] = (double)upperLeftViewPos.x + visiblePortion.getX() + visiblePortion.getWidth();
        srcRecCorners[3] = (double)upperLeftViewPos.y + visiblePortion.getY() + visiblePortion.getHeight();
        this.getViewToMiniMapTransform(this.getMappedComponent()).transform(srcRecCorners, 0, dstRecCorners, 0, srcRecCorners.length / 2);
        return new Rectangle((int)dstRecCorners[0], (int)dstRecCorners[1], (int)(dstRecCorners[2] - dstRecCorners[0]), (int)(dstRecCorners[3] - dstRecCorners[1]));
    }

    protected void scrollSubjectTo(int upperLeftX, int upperLeftY) {
        AffineTransform at = null;
        try {
            at = this.getViewToMiniMapTransform(this.getMappedComponent()).createInverse();
        }
        catch (NoninvertibleTransformException nite) {
            nite.printStackTrace();
            return;
        }
        double[] srcPoints = new double[2];
        double[] destPoints = new double[2];
        srcPoints[0] = upperLeftX;
        srcPoints[1] = upperLeftY;
        at.transform(srcPoints, 0, destPoints, 0, 1);
        if (destPoints[0] < 0.0) {
            destPoints[0] = 0.0;
        }
        if (destPoints[1] < 0.0) {
            destPoints[1] = 0.0;
        }
        this.m_subject.getViewport().setViewPosition(new Point((int)destPoints[0], (int)destPoints[1]));
    }

    protected int[] getUpperLeftPointsFromCenter(int centerX, int centerY) {
        int[] upperLeft = new int[2];
        Rectangle oldRectangle = this.getViewRectangle();
        upperLeft[0] = centerX - oldRectangle.width / 2;
        upperLeft[1] = centerY - oldRectangle.height / 2;
        return upperLeft;
    }

    class MappedDrawingChangeListener
    implements DrawingChangeListener {
        MappedDrawingChangeListener() {
        }

        public void drawingInvalidated(DrawingChangeEvent e) {
            MiniMapView.this.repaint();
        }

        public void drawingRequestUpdate(DrawingChangeEvent e) {
            MiniMapView.this.repaint();
        }

        public void drawingTitleChanged(DrawingChangeEvent e) {
        }
    }

    class SubjectListener
    implements ChangeListener {
        SubjectListener() {
        }

        public void stateChanged(ChangeEvent e) {
            MiniMapView.this.repaint();
        }
    }

    public class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent e) {
            int[] rectangleUpperLeft = MiniMapView.this.getUpperLeftPointsFromCenter(e.getX(), e.getY());
            MiniMapView.this.scrollSubjectTo(rectangleUpperLeft[0], rectangleUpperLeft[1]);
        }

        public void mouseDragged(MouseEvent e) {
            int[] rectangleUpperLeft = MiniMapView.this.getUpperLeftPointsFromCenter(e.getX(), e.getY());
            MiniMapView.this.scrollSubjectTo(rectangleUpperLeft[0], rectangleUpperLeft[1]);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

